/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.events.RuleStatusInfoEvent;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class RuleMetric
implements OpenhabCoreMeterBinder,
EventSubscriber {
    public static final String METRIC_NAME = "openhab.rule.runs";
    public static final String RULES_TOPIC_PREFIX = "openhab/rules/";
    public static final String RULES_TOPIC_SUFFIX = "/state";
    private final Logger logger = LoggerFactory.getLogger(RuleMetric.class);
    private static final Tag CORE_RULE_METRIC_TAG = Tag.of("metric", "openhab.core.metric.rules");
    private static final String RULE_ID_TAG_NAME = "rule";
    private static final String RULE_NAME_TAG_NAME = "rulename";
    private @Nullable MeterRegistry meterRegistry;
    private final Set<Tag> tags = new HashSet<Tag>();
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;
    private BundleContext bundleContext;
    private RuleRegistry ruleRegistry;

    public RuleMetric(BundleContext bundleContext, Collection<Tag> tags, RuleRegistry ruleRegistry) {
        this.tags.addAll(tags);
        this.tags.add(CORE_RULE_METRIC_TAG);
        this.bundleContext = bundleContext;
        this.ruleRegistry = ruleRegistry;
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry meterRegistry) {
        this.unbind();
        this.logger.debug("RuleMetric is being bound...");
        this.meterRegistry = meterRegistry;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        for (Meter meter : meterRegistry.getMeters()) {
            if (!meter.getId().getTags().contains(CORE_RULE_METRIC_TAG)) continue;
            meterRegistry.remove(meter);
        }
        this.meterRegistry = null;
        ServiceRegistration<?> eventSubscriberRegistration = this.eventSubscriberRegistration;
        if (eventSubscriberRegistration != null) {
            eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(RuleStatusInfoEvent.TYPE);
    }

    public void receive(Event event) {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            this.logger.trace("Measurement not started. Skipping rule event processing");
            return;
        }
        String topic = event.getTopic();
        String ruleId = topic.substring(RULES_TOPIC_PREFIX.length(), topic.lastIndexOf(RULES_TOPIC_SUFFIX));
        if (!event.getPayload().contains(RuleStatus.RUNNING.name())) {
            this.logger.trace("Skipping rule status info with status other than RUNNING {}", (Object)event.getPayload());
            return;
        }
        this.logger.debug("Rule {} RUNNING - updating metric.", (Object)ruleId);
        HashSet<Tag> tagsWithRule = new HashSet<Tag>(this.tags);
        tagsWithRule.add(Tag.of(RULE_ID_TAG_NAME, ruleId));
        String ruleName = this.getRuleName(ruleId);
        if (ruleName != null) {
            tagsWithRule.add(Tag.of(RULE_NAME_TAG_NAME, ruleName));
        }
        meterRegistry.counter(METRIC_NAME, tagsWithRule).increment();
    }

    private @Nullable String getRuleName(String ruleId) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleId);
        return rule == null ? null : rule.getName();
    }
}

