/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServerController;
import org.ops4j.pax.web.service.jetty.internal.PriorityValue;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.osgi.framework.Bundle;

public class JettyServerControllerFactory
implements ServerControllerFactory {
    static Comparator<PriorityValue<?>> priorityComparator = Comparator.comparingInt(PriorityValue::getPriority);
    private final Bundle paxWebJettyBundle;
    private final ClassLoader classLoader;
    private final Map<String, JettyServerController> serverControllers = new HashMap<String, JettyServerController>();
    private final JettyFactory jettyFactory;
    private final Set<PriorityValue<Handler>> handlers;
    private final Set<PriorityValue<HttpConfiguration.Customizer>> customizers;

    public JettyServerControllerFactory(Bundle paxWebJettyBundle, ClassLoader classLoader) {
        this.paxWebJettyBundle = paxWebJettyBundle;
        this.classLoader = classLoader;
        this.handlers = new TreeSet(priorityComparator);
        this.customizers = new TreeSet(priorityComparator);
        this.jettyFactory = new JettyFactory(paxWebJettyBundle, classLoader);
    }

    public synchronized ServerController createServerController(Configuration configuration) {
        if (this.serverControllers.containsKey(configuration.id())) {
            return this.serverControllers.get(configuration.id());
        }
        JettyServerController controller = new JettyServerController(this.paxWebJettyBundle, this.classLoader, this.jettyFactory, configuration);
        this.serverControllers.put(configuration.id(), controller);
        controller.setHandlers(this.handlers);
        controller.setCustomizers(this.customizers);
        return controller;
    }

    public void releaseServerController(ServerController controller, Configuration configuration) {
        if (controller instanceof JettyServerController) {
            this.serverControllers.remove(configuration.id(), controller);
        }
    }

    public void addHandler(Handler handler, int ranking) {
        this.handlers.add(new PriorityValue<Handler>(handler, ranking));
    }

    public void removeHandler(Handler handler) {
        this.handlers.removeIf(pv -> pv.getValue() == handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomizer(HttpConfiguration.Customizer customizer, int ranking) {
        Map<String, JettyServerController> map = this.serverControllers;
        synchronized (map) {
            PriorityValue<HttpConfiguration.Customizer> pv = new PriorityValue<HttpConfiguration.Customizer>(customizer, ranking);
            this.customizers.add(pv);
            for (JettyServerController serverController : this.serverControllers.values()) {
                serverController.setCustomizers(this.customizers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomizer(HttpConfiguration.Customizer customizer) {
        Map<String, JettyServerController> map = this.serverControllers;
        synchronized (map) {
            this.customizers.removeIf(pv -> pv.getValue() == customizer);
            for (JettyServerController serverController : this.serverControllers.values()) {
                serverController.removeCustomizer(customizer);
            }
        }
    }
}

