/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.spi.support.FormattingTriple;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LoggerConsumer;

public class BufferingLog
implements PaxLogger {
    private final List<LogPackage> m_queue;
    private final String m_fqcn;
    private PaxContext m_context = new PaxContext();

    public BufferingLog(Bundle bundle, String categoryName) {
        this.m_fqcn = this.getClass().getName();
        this.m_queue = new ArrayList<LogPackage>();
    }

    void flush(PaxLogger destination) {
        for (LogPackage pack : this.m_queue) {
            String fqcn = pack.getFqcn();
            Throwable throwable = pack.getException();
            String message = pack.getMessage();
            this.getPaxContext().putAll(pack.getContext());
            LogType logType = pack.getType();
            int logTypeAsInt = logType.getType();
            switch (logTypeAsInt) {
                case 1: {
                    destination.debug(message, (Object)throwable);
                    break;
                }
                case 0: {
                    destination.trace(message, (Object)throwable);
                    break;
                }
                case 2: {
                    destination.info(message, (Object)throwable);
                    break;
                }
                case 3: {
                    destination.warn(message, (Object)throwable);
                    break;
                }
                case 4: {
                    destination.error(message, (Object)throwable);
                    break;
                }
                case 5: {
                    destination.fatal(message, (Object)throwable);
                }
            }
            this.getPaxContext().clear();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public boolean isTraceEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public boolean isDebugEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public boolean isInfoEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public boolean isWarnEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public boolean isErrorEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public boolean isFatalEnabled(PaxMarker marker) {
        return true;
    }

    @Override
    public void trace(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void trace(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void trace(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void debug(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void debug(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void debug(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void info(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void info(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void info(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void info(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void warn(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void warn(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void warn(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void error(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void error(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void error(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void fatal(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void fatal(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void fatal(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void fatal(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void audit(String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void audit(LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void audit(PaxMarker marker, String message) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, message, null, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arg1, arg2);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void audit(PaxMarker marker, String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, false, arguments);
        LogPackage p = new LogPackage(this.m_fqcn, LogType.audit, ft.getMessage(), ft.getThrowable(), this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public <E extends Exception> void audit(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        consumer.accept(this);
    }

    @Override
    public void fqtrace(String fqcn, String message) {
        this.trace(message);
    }

    @Override
    public void fqdebug(String fqcn, String message) {
        this.debug(message);
    }

    @Override
    public void fqinfo(String fqcn, String message) {
        this.info(message);
    }

    @Override
    public void fqwarn(String fqcn, String message) {
        this.warn(message);
    }

    @Override
    public void fqerror(String fqcn, String message) {
        this.error(message);
    }

    @Override
    public void fqfatal(String fqcn, String message) {
        this.fatal(message);
    }

    @Override
    public void fqtrace(String fqcn, PaxMarker marker, String message) {
        this.trace(marker, message);
    }

    @Override
    public void fqdebug(String fqcn, PaxMarker marker, String message) {
        this.debug(marker, message);
    }

    @Override
    public void fqinfo(String fqcn, PaxMarker marker, String message) {
        this.info(marker, message);
    }

    @Override
    public void fqwarn(String fqcn, PaxMarker marker, String message) {
        this.warn(marker, message);
    }

    @Override
    public void fqerror(String fqcn, PaxMarker marker, String message) {
        this.error(marker, message);
    }

    @Override
    public void fqfatal(String fqcn, PaxMarker marker, String message) {
        this.fatal(marker, message);
    }

    @Override
    public void fqtrace(String fqcn, String message, Throwable t) {
        this.trace(message, (Object)t);
    }

    @Override
    public void fqdebug(String fqcn, String message, Throwable t) {
        this.debug(message, (Object)t);
    }

    @Override
    public void fqinfo(String fqcn, String message, Throwable t) {
        this.info(message, (Object)t);
    }

    @Override
    public void fqwarn(String fqcn, String message, Throwable t) {
        this.warn(message, (Object)t);
    }

    @Override
    public void fqerror(String fqcn, String message, Throwable t) {
        this.error(message, (Object)t);
    }

    @Override
    public void fqfatal(String fqcn, String message, Throwable t) {
        this.fatal(message, (Object)t);
    }

    @Override
    public void fqtrace(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.trace(message, (Object)marker, (Object)t);
    }

    @Override
    public void fqdebug(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.debug(message, (Object)marker, (Object)t);
    }

    @Override
    public void fqinfo(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.info(message, (Object)marker, (Object)t);
    }

    @Override
    public void fqwarn(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.warn(message, (Object)marker, (Object)t);
    }

    @Override
    public void fqerror(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.error(message, (Object)marker, (Object)t);
    }

    @Override
    public void fqfatal(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fatal(message, (Object)marker, (Object)t);
    }

    @Override
    public int getPaxLogLevel() {
        return 0;
    }

    @Override
    public LogLevel getLogLevel() {
        return LogLevel.TRACE;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_context;
    }

    private static class LogPackage {
        private final String m_fqcn;
        private final LogType m_type;
        private final String m_message;
        private final Throwable m_exception;
        private final Map<String, Object> m_context;

        public LogPackage(String fqcn, LogType type, String message, Throwable exception, Map<String, Object> context) {
            this.m_fqcn = fqcn;
            this.m_type = type;
            this.m_message = message;
            this.m_exception = exception;
            this.m_context = context;
            if (this.m_exception != null) {
                this.m_exception.fillInStackTrace();
            }
        }

        public String getFqcn() {
            return this.m_fqcn;
        }

        public String getMessage() {
            return this.m_message;
        }

        public Throwable getException() {
            return this.m_exception;
        }

        public LogType getType() {
            return this.m_type;
        }

        public Map<String, Object> getContext() {
            return this.m_context;
        }
    }

    private static class LogType {
        private static final int TRACE_INT = 0;
        private static final int DEBUG_INT = 1;
        private static final int INFO_INT = 2;
        private static final int WARN_INT = 3;
        private static final int ERROR_INT = 4;
        private static final int FATAL_INT = 5;
        private static final int AUDIT_INT = 6;
        private static LogType trace = new LogType(0);
        private static LogType debug = new LogType(1);
        private static LogType info = new LogType(2);
        private static LogType warn = new LogType(3);
        private static LogType error = new LogType(4);
        private static LogType fatal = new LogType(5);
        private static LogType audit = new LogType(6);
        private final int m_type;

        private LogType(int type) {
            this.m_type = type;
        }

        private int getType() {
            return this.m_type;
        }
    }
}

