/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.BundleContext;

public class AllOSGi<T>
extends OSGiImpl<T> {
    @SafeVarargs
    public AllOSGi(OSGi<T> ... programs) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            ArrayList<OSGiResult> results = new ArrayList<OSGiResult>(programs.length);
            try {
                for (OSGi program : programs) {
                    results.add(program.run(bundleContext, op));
                }
            }
            catch (Exception e) {
                AllOSGi.cleanUp(results);
                throw e;
            }
            return new OSGiResultImpl(() -> AllOSGi.cleanUp(results));
        });
    }

    private static void cleanUp(ArrayList<OSGiResult> results) {
        ListIterator<OSGiResult> iterator = results.listIterator(results.size());
        while (iterator.hasPrevious()) {
            try {
                iterator.previous().close();
            }
            catch (Exception exception) {}
        }
    }
}

