/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.JvmTypeReferenceUtil;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.ConflictingDefaultOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class JvmGenericTypeValidator
extends AbstractDeclarativeValidator {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private ILogicalContainerProvider containerProvider;
    @Inject
    private CommonTypeComputationServices services;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void interceptRoot(EObject o) {
        EList contents = o.eResource().getContents();
        if (contents.get(0) != o) {
            return;
        }
        this.checkJvmGenericTypes((List<? extends EObject>)contents);
    }

    protected void checkJvmGenericTypes(List<? extends EObject> contents) {
        HashSet processed = new HashSet();
        contents.stream().filter(JvmGenericType.class::isInstance).map(JvmGenericType.class::cast).filter(this::shouldBeValidated).forEach(t -> this.checkJvmGenericType((JvmGenericType)t, processed));
    }

    protected boolean shouldBeValidated(JvmIdentifiableElement element) {
        return !this.associations.getSourceElements((EObject)element).isEmpty();
    }

    protected void checkJvmGenericType(JvmGenericType type, Set<EObject> processed) {
        EObject sourceType = this.getPrimarySourceElement(type);
        if (!processed.add(sourceType)) {
            return;
        }
        this.handleExceptionDuringValidation(() -> this.checkDefaultSuperConstructor(sourceType, type));
        this.handleExceptionDuringValidation(() -> this.checkSuperTypes(sourceType, type));
        IterableExtensions.toList((Iterable)type.getDeclaredFields()).stream().filter(this::shouldBeValidated).forEach(field -> this.handleExceptionDuringValidation(() -> this.checkField((JvmField)field)));
        this.handleExceptionDuringValidation(() -> this.checkMemberNamesAreUnique(type));
        this.handleExceptionDuringValidation(() -> this.checkDuplicateAndOverriddenFunctions(sourceType, type));
        EList members = type.getMembers();
        this.handleExceptionDuringValidation(() -> this.checkJvmExecutables((List<? extends JvmMember>)members));
        if (this.isAnonymous(type)) {
            this.handleExceptionDuringValidation(() -> this.checkAnonymousClassStaticMembers(type));
        }
        members.forEach(member -> EcoreUtil2.eAllOfType((EObject)member, JvmGenericType.class).stream().filter(this::shouldBeValidated).forEach(nestedType -> this.handleExceptionDuringValidation(() -> this.checkJvmGenericType((JvmGenericType)nestedType, processed))));
    }

    protected EObject getPrimarySourceElement(JvmGenericType type) {
        return this.associations.getPrimarySourceElement((EObject)type);
    }

    protected void checkJvmExecutables(List<? extends JvmMember> contents) {
        contents.stream().filter(this::shouldBeValidated).filter(JvmExecutable.class::isInstance).map(JvmExecutable.class::cast).forEach(this::checkJvmExecutable);
    }

    protected void checkSuperTypes(EObject sourceType, JvmGenericType type) {
        if (this.hasCycleInHierarchy(type, new HashSet<JvmGenericType>())) {
            this.error("The inheritance hierarchy of " + Strings.notNull((Object)type.getSimpleName()) + " contains cycles", sourceType, this.getFeatureForIssue(sourceType), "org.eclipse.xtext.xbase.validation.IssueCodes.cyclic_inheritance", new String[0]);
        }
        EList superTypes = type.getSuperTypes();
        String mismatchedSuperInterfaceErrorPrerix = type.isInterface() ? "Extended" : "Implemented";
        int multiFeatureIndex = -1;
        HashSet<String> seen = new HashSet<String>();
        int i = 0;
        while (i < superTypes.size()) {
            JvmTypeReference extendedType = (JvmTypeReference)superTypes.get(i);
            EObject associated = this.getSuperTypeSourceElement(extendedType);
            if (associated == null) {
                seen.add(extendedType.getIdentifier());
            } else {
                EStructuralFeature eContainingFeature = associated.eContainingFeature();
                int featureIndex = -1;
                ++multiFeatureIndex;
                if (eContainingFeature.isMany()) {
                    featureIndex = multiFeatureIndex;
                }
                if (JvmTypeReferenceUtil.isExpectedAsInterface((JvmTypeReference)extendedType)) {
                    if (!this.isInterface(extendedType) && !this.isAnnotation(extendedType)) {
                        this.error(mismatchedSuperInterfaceErrorPrerix + " interface must be an interface", sourceType, eContainingFeature, featureIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.interface_expected", new String[0]);
                    } else if (!seen.add(extendedType.getIdentifier())) {
                        this.error(String.format("Duplicate interface %s for the type %s", extendedType.getSimpleName(), type.getSimpleName()), sourceType, eContainingFeature, featureIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_interface", new String[0]);
                    }
                } else if (JvmTypeReferenceUtil.isExpectedAsClass((JvmTypeReference)extendedType) && !this.isClass(extendedType)) {
                    this.error("Superclass must be a class", sourceType, eContainingFeature, "org.eclipse.xtext.xbase.validation.IssueCodes.class_expected", new String[0]);
                }
                seen.add(extendedType.getIdentifier());
                if (this.isFinal(extendedType)) {
                    this.error("Attempt to override final class", sourceType, eContainingFeature, "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final", new String[0]);
                }
                this.checkWildcardSupertype(sourceType, Strings.notNull((Object)type.getSimpleName()), extendedType, eContainingFeature, featureIndex);
            }
            ++i;
        }
    }

    protected boolean isInterface(JvmTypeReference typeRef) {
        return this.isInterface(typeRef.getType());
    }

    protected boolean isInterface(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected boolean isAnnotation(JvmTypeReference typeRef) {
        return this.isAnnotation(typeRef.getType());
    }

    protected boolean isAnnotation(JvmType type) {
        return type instanceof JvmAnnotationType;
    }

    protected boolean isFinal(JvmTypeReference typeRef) {
        return typeRef.getType() instanceof JvmGenericType && ((JvmGenericType)typeRef.getType()).isFinal();
    }

    protected boolean isClass(JvmTypeReference typeRef) {
        return typeRef.getType() instanceof JvmGenericType && !((JvmGenericType)typeRef.getType()).isInterface();
    }

    protected boolean isAnonymous(JvmGenericType type) {
        return type.isAnonymous();
    }

    protected EObject getSuperTypeSourceElement(JvmTypeReference extendedType) {
        EObject associated = this.associations.getPrimarySourceElement((EObject)extendedType);
        while (associated == null && extendedType instanceof XComputedTypeReference) {
            extendedType = ((XComputedTypeReference)extendedType).getEquivalent();
            associated = this.associations.getPrimarySourceElement((EObject)extendedType);
        }
        return associated;
    }

    protected void checkAnonymousClassStaticMembers(JvmGenericType type) {
        type.getMembers().stream().filter(this::shouldBeValidated).forEach(member -> {
            JvmField field;
            EObject source = this.associations.getPrimarySourceElement((EObject)member);
            if (member instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)member;
                if (operation.isStatic()) {
                    this.error("A method of an anonymous class cannot be static.", source, this.getFeatureForIssue(source), -1, "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_static_method", new String[0]);
                }
            } else if (member instanceof JvmField && (field = (JvmField)member).isStatic()) {
                if (!field.isFinal()) {
                    this.error("A static field of an anonymous class must be final.", source, this.getFeatureForIssue(source), -1, "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_static_field", new String[0]);
                } else if (!field.isConstant()) {
                    XExpression initExpression = (XExpression)Iterables.getLast((Iterable)Iterables.filter((Iterable)source.eContents(), XExpression.class));
                    this.error("A static field of an anonymous class must be initialized with a constant expression.", source, initExpression.eContainingFeature(), -1, "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_static_field", new String[0]);
                }
            }
        });
    }

    protected void checkDefaultSuperConstructor(EObject sourceType, JvmGenericType type) {
        JvmType superType;
        Iterable constructors = Iterables.filter((Iterable)type.getMembers(), JvmConstructor.class);
        if (type.getExtendedClass() != null && (superType = type.getExtendedClass().getType()) instanceof JvmGenericType) {
            Iterable superConstructors = ((JvmGenericType)superType).getDeclaredConstructors();
            for (JvmConstructor superConstructor : superConstructors) {
                if (!superConstructor.getParameters().isEmpty()) continue;
                return;
            }
            if (Iterables.size((Iterable)constructors) == 1 && this.typeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)constructors.iterator().next())) {
                ArrayList<String> issueData = new ArrayList<String>();
                for (JvmConstructor superConstructor : superConstructors) {
                    issueData.add(EcoreUtil.getURI((EObject)superConstructor).toString());
                    issueData.add(this.getReadableSignature(type.getSimpleName(), (List<JvmFormalParameter>)superConstructor.getParameters()));
                }
                this.error("No default constructor in super type " + superType.getSimpleName() + "." + type.getSimpleName() + " must define an explicit constructor.", sourceType, this.getFeatureForIssue(sourceType), "org.eclipse.xtext.xbase.validation.IssueCodes.missing_constructor", (String[])Iterables.toArray(issueData, String.class));
            } else {
                for (JvmConstructor constructor : constructors) {
                    EList<XExpression> expressions;
                    XExpression expression = this.containerProvider.getAssociatedExpression((JvmIdentifiableElement)constructor);
                    if (!(expression instanceof XBlockExpression) || !(expressions = ((XBlockExpression)expression).getExpressions()).isEmpty() && this.isDelegateConstructorCall((XExpression)expressions.get(0))) continue;
                    EObject source = this.associations.getPrimarySourceElement((EObject)constructor);
                    this.error("No default constructor in super type " + superType.getSimpleName() + ". Another constructor must be invoked explicitly.", source, null, "org.eclipse.xtext.xbase.validation.IssueCodes.must_invoke_super_constructor", new String[0]);
                }
            }
        }
    }

    protected String getReadableSignature(String elementName, List<JvmFormalParameter> parameters) {
        StringBuilder result = new StringBuilder(elementName);
        result.append('(');
        int i = 0;
        while (i < parameters.size()) {
            JvmTypeReference parameterType;
            if (i != 0) {
                result.append(", ");
            }
            if ((parameterType = parameters.get(i).getParameterType()) != null) {
                result.append(parameterType.getSimpleName());
            } else {
                result.append("null");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    protected boolean isDelegateConstructorCall(XExpression expression) {
        if (expression instanceof XFeatureCall) {
            JvmIdentifiableElement feature = ((XFeatureCall)expression).getFeature();
            return feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor;
        }
        return false;
    }

    protected void checkMemberNamesAreUnique(JvmGenericType type) {
        EObject originalSource;
        List<JvmField> withSameName;
        Map<String, List<JvmField>> fieldsByName = this.groupMembersByName((List)type.getMembers(), (Class)JvmField.class);
        Map<String, List<JvmDeclaredType>> typesByName = this.groupMembersByName((List)type.getMembers(), (Class)JvmDeclaredType.class);
        for (String name : fieldsByName.keySet()) {
            withSameName = fieldsByName.get(name);
            if (withSameName.size() <= 1) continue;
            for (JvmField duplicate : withSameName) {
                originalSource = this.associations.getPrimarySourceElement((EObject)duplicate);
                this.error("Duplicate field " + name, originalSource, this.getFeatureForIssue(originalSource), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_field", new String[0]);
            }
        }
        for (String name : typesByName.keySet()) {
            withSameName = typesByName.get(name);
            if (withSameName.size() <= 1) continue;
            for (JvmField duplicate : withSameName) {
                originalSource = this.associations.getPrimarySourceElement((EObject)duplicate);
                this.error("Duplicate nested type " + name, originalSource, this.getFeatureForIssue(originalSource), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
            }
        }
    }

    protected void checkDuplicateAndOverriddenFunctions(EObject sourceType, JvmGenericType type) {
        JavaVersion targetVersion = this.getGeneratorConfig(sourceType).getJavaSourceVersion();
        ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures((JvmDeclaredType)type, targetVersion);
        HashSet<EObject> flaggedOperations = new HashSet<EObject>();
        this.checkDuplicateExecutables(type, resolvedFeatures, flaggedOperations);
        this.checkOverriddenMethods(sourceType, type, resolvedFeatures, flaggedOperations);
        this.checkFunctionOverrides(resolvedFeatures, flaggedOperations);
    }

    private <T1 extends JvmMember, T2 extends T1> Map<String, List<T2>> groupMembersByName(List<T1> members, Class<T2> memberType) {
        return members.stream().filter(this::shouldBeValidated).filter(memberType::isInstance).map(memberType::cast).filter(e -> Objects.nonNull(e.getSimpleName())).collect(Collectors.groupingBy(JvmMember::getSimpleName));
    }

    protected void checkField(JvmField field) {
        JvmTypeReference declaredFieldType = field.getType();
        if (this.isPrimitiveVoid(declaredFieldType)) {
            EObject associated = this.associations.getPrimarySourceElement((EObject)declaredFieldType);
            this.error("void is an invalid type for the field " + field.getSimpleName(), associated, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    protected void checkJvmExecutable(JvmExecutable executable) {
        EObject sourceExecutable = this.associations.getPrimarySourceElement((EObject)executable);
        this.checkParameters(sourceExecutable, executable);
        this.checkExceptions(sourceExecutable, executable);
    }

    protected void checkParameters(EObject sourceExecutable, JvmExecutable executable) {
        EList parameters = executable.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(i);
            EObject sourceParameter = this.associations.getPrimarySourceElement((EObject)parameter);
            if (sourceParameter != null) {
                String leftParameterName = parameter.getName();
                EStructuralFeature sourceParametersFeature = sourceParameter.eContainingFeature();
                int j = i + 1;
                while (j < parameters.size()) {
                    if (Strings.equal((String)leftParameterName, (String)((JvmFormalParameter)parameters.get(j)).getName())) {
                        this.error("Duplicate parameter " + leftParameterName, sourceExecutable, sourceParametersFeature, i, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                        this.error("Duplicate parameter " + leftParameterName, sourceExecutable, sourceParametersFeature, j, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                    }
                    ++j;
                }
                JvmTypeReference parameterType = parameter.getParameterType();
                EObject sourceParameterType = this.associations.getPrimarySourceElement((EObject)parameterType);
                if (sourceParameterType != null && this.isPrimitiveVoid(parameterType)) {
                    this.error("void is an invalid type for the parameter " + parameter.getName() + " of the method " + executable.getSimpleName(), sourceParameterType, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
                }
            }
            ++i;
        }
    }

    protected void checkExceptions(EObject sourceExecutable, JvmExecutable executable) {
        EList exceptions = executable.getExceptions();
        if (exceptions.isEmpty()) {
            return;
        }
        HashSet<String> declaredExceptionNames = new HashSet<String>();
        JvmTypeReference throwableType = this.getServices().getTypeReferences().getTypeForName(Throwable.class, (Notifier)executable, new JvmTypeReference[0]);
        if (throwableType == null) {
            return;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), (EObject)executable);
        LightweightTypeReference throwableReference = owner.toLightweightTypeReference(throwableType);
        int i = 0;
        while (i < exceptions.size()) {
            EObject sourceException;
            JvmTypeReference exception = (JvmTypeReference)exceptions.get(i);
            if (exception.getType() != null && !exception.getType().eIsProxy() && (sourceException = this.associations.getPrimarySourceElement((EObject)exception)) != null) {
                EStructuralFeature containingFeature = sourceException.eContainingFeature();
                if (!throwableReference.isAssignableFrom(exception.getType())) {
                    this.error("No exception of type " + exception.getSimpleName() + " can be thrown; an exception type must be a subclass of Throwable", sourceExecutable, containingFeature, i, "org.eclipse.xtext.xbase.validation.IssueCodes.exception_not_throwable", new String[0]);
                }
                if (!declaredExceptionNames.add(exception.getQualifiedName())) {
                    this.error("Exception " + exception.getSimpleName() + " is declared twice", sourceExecutable, containingFeature, i, "org.eclipse.xtext.xbase.validation.IssueCodes.exception_declared_twice", new String[0]);
                }
            }
            ++i;
        }
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected boolean isPrimitiveVoid(JvmTypeReference typeReference) {
        return typeReference != null && typeReference.getType() != null && !typeReference.getType().eIsProxy() && typeReference.getType() instanceof JvmVoid;
    }

    private boolean hasCycleInHierarchy(JvmGenericType type, Set<JvmGenericType> processedSuperTypes) {
        JvmGenericType container = type;
        do {
            if (!processedSuperTypes.contains(container)) continue;
            return true;
        } while ((container = container.getDeclaringType()) != null);
        processedSuperTypes.add(type);
        for (JvmTypeReference superTypeRef : type.getSuperTypes()) {
            if (!(superTypeRef.getType() instanceof JvmGenericType) || !this.hasCycleInHierarchy((JvmGenericType)superTypeRef.getType(), processedSuperTypes)) continue;
            return true;
        }
        processedSuperTypes.remove(type);
        return false;
    }

    protected void checkWildcardSupertype(EObject sourceElement, String name, JvmTypeReference superTypeReference, EStructuralFeature feature, int index) {
        if (this.isInvalidWildcard(superTypeReference)) {
            this.error("The type " + name + " cannot extend or implement " + superTypeReference.getIdentifier() + ". A supertype may not specify any wildcard", sourceElement, feature, index, "org.eclipse.xtext.xbase.validation.IssueCodes.wildcard_in_supertype", new String[0]);
        }
    }

    protected boolean isInvalidWildcard(JvmTypeReference typeRef) {
        if (typeRef instanceof JvmWildcardTypeReference) {
            return true;
        }
        if (typeRef instanceof JvmParameterizedTypeReference) {
            for (JvmTypeReference typeArgument : ((JvmParameterizedTypeReference)typeRef).getArguments()) {
                if (!(typeArgument instanceof JvmWildcardTypeReference)) continue;
                return true;
            }
        } else if (typeRef instanceof JvmSpecializedTypeReference) {
            return this.isInvalidWildcard(((JvmSpecializedTypeReference)typeRef).getEquivalent());
        }
        return false;
    }

    protected EStructuralFeature getFeatureForIssue(EObject object) {
        return object.eClass().getEStructuralFeature("name");
    }

    protected void checkDuplicateExecutables(JvmGenericType inferredType, ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        List<IResolvedOperation> declaredOperations = resolvedFeatures.getDeclaredOperations();
        this.checkDuplicateExecutables(inferredType, declaredOperations, erasedSignature -> resolvedFeatures.getDeclaredOperations((String)erasedSignature), flaggedOperations);
        List<IResolvedConstructor> declaredConstructors = resolvedFeatures.getDeclaredConstructors();
        this.checkDuplicateExecutables(inferredType, declaredConstructors, erasedSignature -> {
            if (declaredConstructors.size() == 1) {
                if (erasedSignature.equals(((IResolvedConstructor)declaredConstructors.get(0)).getResolvedErasureSignature())) {
                    return declaredConstructors;
                }
                return Collections.emptyList();
            }
            ArrayList<IResolvedConstructor> result = new ArrayList<IResolvedConstructor>(declaredConstructors.size());
            for (IResolvedConstructor constructor : declaredConstructors) {
                if (!erasedSignature.equals(constructor.getResolvedErasureSignature())) continue;
                result.add(constructor);
            }
            return result;
        }, flaggedOperations);
    }

    protected <Executable extends IResolvedExecutable> void checkDuplicateExecutables(JvmGenericType inferredType, List<Executable> declaredOperations, Function<String, List<Executable>> bySignature, Set<EObject> flaggedOperations) {
        HashSet processed = new HashSet();
        for (IResolvedExecutable declaredExecutable : declaredOperations) {
            List<Executable> sameErasure;
            if (processed.contains(declaredExecutable) || (sameErasure = bySignature.apply(declaredExecutable.getResolvedErasureSignature())).size() <= 1) continue;
            HashMultimap perSignature = HashMultimap.create((int)sameErasure.size(), (int)2);
            block1: for (IResolvedExecutable executable : sameErasure) {
                for (LightweightTypeReference parameterType : executable.getResolvedParameterTypes()) {
                    if (parameterType.isUnknown()) continue block1;
                }
                perSignature.put((Object)executable.getResolvedSignature(), (Object)executable);
            }
            if (perSignature.size() <= 1) continue;
            for (Collection sameSignature : perSignature.asMap().values()) {
                for (IResolvedExecutable operationWithSameSignature : sameSignature) {
                    JvmExecutable executable = operationWithSameSignature.getDeclaration();
                    EObject otherSource = this.associations.getPrimarySourceElement((EObject)executable);
                    if (!flaggedOperations.add(otherSource)) continue;
                    if (sameSignature.size() > 1) {
                        this.error("Duplicate " + this.typeLabel(executable) + " " + operationWithSameSignature.getSimpleSignature() + " in type " + inferredType.getSimpleName(), otherSource, this.getFeatureForIssue(otherSource), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                        continue;
                    }
                    this.error("The " + this.typeLabel(executable) + " " + operationWithSameSignature.getSimpleSignature() + " has the same erasure " + operationWithSameSignature.getResolvedErasureSignature() + " as another " + this.typeLabel(executable) + " in type " + inferredType.getSimpleName(), otherSource, this.getFeatureForIssue(otherSource), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                }
            }
        }
    }

    protected void checkOverriddenMethods(EObject sourceType, JvmGenericType inferredType, ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        boolean doCheckAbstract;
        ArrayList<IResolvedOperation> operationsMissingImplementation = null;
        boolean bl = doCheckAbstract = !inferredType.isAbstract();
        if (doCheckAbstract) {
            operationsMissingImplementation = new ArrayList<IResolvedOperation>();
        }
        ContextualVisibilityHelper visibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, resolvedFeatures.getType());
        boolean flaggedType = false;
        for (IResolvedOperation operation : resolvedFeatures.getAllOperations()) {
            JvmDeclaredType operationDeclaringType = operation.getDeclaration().getDeclaringType();
            if (operationDeclaringType == inferredType) continue;
            if (operationsMissingImplementation != null && operation.getDeclaration().isAbstract()) {
                operationsMissingImplementation.add(operation);
            }
            if (!visibilityHelper.isVisible((JvmMember)operation.getDeclaration())) continue;
            String erasureSignature = operation.getResolvedErasureSignature();
            List<IResolvedOperation> declaredOperationsWithSameErasure = resolvedFeatures.getDeclaredOperations(erasureSignature);
            for (IResolvedOperation localOperation : declaredOperationsWithSameErasure) {
                if (localOperation.isOverridingOrImplementing(operation.getDeclaration()).isOverridingOrImplementing()) continue;
                EObject source = this.findPrimarySourceElement(localOperation);
                if (operation.getDeclaration().isStatic() && !localOperation.getDeclaration().isStatic()) {
                    if (this.isInterface((JvmType)operationDeclaringType) || !flaggedOperations.add(source)) continue;
                    this.error("The instance method " + localOperation.getSimpleSignature() + " cannot override the static method " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + ".", source, this.getFeatureForIssue(source), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                    continue;
                }
                if (!operation.getDeclaration().isStatic() && localOperation.getDeclaration().isStatic()) {
                    if (!flaggedOperations.add(source)) continue;
                    this.error("The static method " + localOperation.getSimpleSignature() + " cannot hide the instance method " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + ".", source, this.getFeatureForIssue(source), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                    continue;
                }
                if (!flaggedOperations.add(source)) continue;
                this.error("Name clash: The method " + localOperation.getSimpleSignature() + " of type " + inferredType.getSimpleName() + " has the same erasure as " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + " but does not override it.", source, this.getFeatureForIssue(source), "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
            }
            if (!(operation instanceof ConflictingDefaultOperation) || !this.contributesToConflict(inferredType, (ConflictingDefaultOperation)operation) || flaggedType) continue;
            IResolvedOperation conflictingOperation = ((ConflictingDefaultOperation)operation).getConflictingOperations().get(0);
            String[] uris = new String[]{this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + "|" + EcoreUtil.getURI((EObject)operation.getDeclaration()).toString(), this.getDeclaratorName((JvmFeature)conflictingOperation.getDeclaration()) + "|" + EcoreUtil.getURI((EObject)conflictingOperation.getDeclaration()).toString()};
            if (!operation.getDeclaration().isAbstract() && !conflictingOperation.getDeclaration().isAbstract()) {
                this.error("The type " + inferredType.getSimpleName() + " inherits multiple implementations of the method " + conflictingOperation.getSimpleSignature() + " from " + this.getDeclaratorName((JvmFeature)conflictingOperation.getDeclaration()) + " and " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + ".", sourceType, this.getFeatureForIssue(sourceType), "org.eclipse.xtext.xbase.validation.IssueCodes.conflicting_default_methods", uris);
            } else {
                IResolvedOperation nonabstractOp;
                IResolvedOperation abstractOp;
                if (operation.getDeclaration().isAbstract()) {
                    abstractOp = operation;
                    nonabstractOp = conflictingOperation;
                } else {
                    abstractOp = conflictingOperation;
                    nonabstractOp = operation;
                }
                this.error("The non-abstract method " + nonabstractOp.getSimpleSignature() + " inherited from " + this.getDeclaratorName((JvmFeature)nonabstractOp.getDeclaration()) + " conflicts with the method " + abstractOp.getSimpleSignature() + " inherited from " + this.getDeclaratorName((JvmFeature)abstractOp.getDeclaration()) + ".", sourceType, this.getFeatureForIssue(sourceType), "org.eclipse.xtext.xbase.validation.IssueCodes.conflicting_default_methods", uris);
            }
            flaggedType = true;
        }
        if (operationsMissingImplementation != null && !operationsMissingImplementation.isEmpty() && !flaggedType) {
            this.reportMissingImplementations(sourceType, inferredType, operationsMissingImplementation);
        }
    }

    protected EObject findPrimarySourceElement(IResolvedOperation operation) {
        return this.associations.getPrimarySourceElement((EObject)operation.getDeclaration());
    }

    private boolean contributesToConflict(JvmGenericType rootType, ConflictingDefaultOperation conflictingDefaultOperation) {
        HashSet<JvmDeclaredType> involvedInterfaces = new HashSet<JvmDeclaredType>();
        involvedInterfaces.add(((JvmOperation)conflictingDefaultOperation.getDeclaration()).getDeclaringType());
        for (IResolvedOperation conflictingOperation : conflictingDefaultOperation.getConflictingOperations()) {
            involvedInterfaces.add(conflictingOperation.getDeclaration().getDeclaringType());
        }
        RecursionGuard<JvmDeclaredType> recursionGuard = new RecursionGuard<JvmDeclaredType>();
        if (rootType.isInterface()) {
            int contributingCount = 0;
            for (JvmTypeReference typeRef : rootType.getExtendedInterfaces()) {
                JvmType rawType = typeRef.getType();
                if (!(rawType instanceof JvmDeclaredType) || !this.contributesToConflict((JvmDeclaredType)rawType, involvedInterfaces, recursionGuard)) continue;
                ++contributingCount;
            }
            return contributingCount >= 2;
        }
        return this.contributesToConflict((JvmDeclaredType)rootType, involvedInterfaces, recursionGuard);
    }

    private boolean contributesToConflict(JvmDeclaredType type, Set<JvmDeclaredType> involvedInterfaces, RecursionGuard<JvmDeclaredType> guard) {
        if (!guard.tryNext(type)) {
            return false;
        }
        if (involvedInterfaces.contains(type)) {
            return true;
        }
        for (JvmTypeReference typeRef : type.getExtendedInterfaces()) {
            JvmType rawType = typeRef.getType();
            if (!(rawType instanceof JvmDeclaredType) || !this.contributesToConflict((JvmDeclaredType)rawType, involvedInterfaces, guard)) continue;
            return true;
        }
        return false;
    }

    protected void reportMissingImplementations(EObject sourceType, JvmGenericType inferredType, List<IResolvedOperation> operationsMissingImplementation) {
        boolean needsNewLine;
        StringBuilder errorMsg = new StringBuilder();
        String name = inferredType.getSimpleName();
        boolean bl = needsNewLine = operationsMissingImplementation.size() > 1;
        if (this.isAnonymous(inferredType)) {
            JvmTypeReference superType = (JvmTypeReference)Iterables.getLast((Iterable)inferredType.getSuperTypes());
            errorMsg.append("The anonymous subclass of ").append(superType.getSimpleName());
            errorMsg.append(" does not implement ");
        } else {
            errorMsg.append("The class ").append(name);
            errorMsg.append(" must be defined abstract because it does not implement ");
        }
        if (needsNewLine) {
            errorMsg.append("its inherited abstract methods ");
        }
        int i = 0;
        while (i < operationsMissingImplementation.size() && i < 3) {
            IResolvedOperation operation = operationsMissingImplementation.get(i);
            if (needsNewLine) {
                errorMsg.append("\n- ");
            }
            errorMsg.append(operation.getSimpleSignature());
            ++i;
        }
        int numUnshownOperations = operationsMissingImplementation.size() - 3;
        if (numUnshownOperations > 0) {
            errorMsg.append("\nand " + numUnshownOperations + " more.");
        }
        List uris = operationsMissingImplementation.stream().map(from -> EcoreUtil.getURI((EObject)from.getDeclaration()).toString()).collect(Collectors.toList());
        if (this.isAnonymous(inferredType)) {
            JvmTypeReference superType = (JvmTypeReference)Iterables.getLast((Iterable)inferredType.getSuperTypes());
            EObject associated = this.getSuperTypeSourceElement(superType);
            EStructuralFeature eContainingFeature = associated.eContainingFeature();
            this.error(errorMsg.toString(), sourceType, eContainingFeature, "org.eclipse.xtext.xbase.validation.IssueCodes.anonymous_class_missing_members", (String[])Iterables.toArray(uris, String.class));
        } else {
            this.error(errorMsg.toString(), sourceType, this.getFeatureForIssue(sourceType), "org.eclipse.xtext.xbase.validation.IssueCodes.class_must_be_defined_abstract", (String[])Iterables.toArray(uris, String.class));
        }
    }

    protected void checkFunctionOverrides(ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        for (IResolvedOperation operation : resolvedFeatures.getDeclaredOperations()) {
            this.checkFunctionOverrides(operation, flaggedOperations);
        }
    }

    protected void checkFunctionOverrides(IResolvedOperation operation, Set<EObject> flaggedOperations) {
        List<IResolvedOperation> allInherited;
        EObject sourceElement = this.findPrimarySourceElement(operation);
        if (sourceElement != null && !(allInherited = operation.getOverriddenAndImplementedMethods()).isEmpty() && flaggedOperations.add(sourceElement)) {
            this.checkFunctionOverrides(sourceElement, operation, allInherited);
        }
    }

    protected void checkFunctionOverrides(EObject sourceElement, IResolvedOperation resolved, List<IResolvedOperation> allInherited) {
        ArrayList<IResolvedOperation> exceptionMismatch = null;
        for (IResolvedOperation inherited : allInherited) {
            if (!inherited.getOverrideCheckResult().hasProblems()) continue;
            EnumSet<IOverrideCheckResult.OverrideCheckDetails> details = inherited.getOverrideCheckResult().getDetails();
            if (details.contains((Object)IOverrideCheckResult.OverrideCheckDetails.IS_FINAL)) {
                this.error("Attempt to override final method " + inherited.getSimpleSignature(), sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final", new String[0]);
                continue;
            }
            if (details.contains((Object)IOverrideCheckResult.OverrideCheckDetails.REDUCED_VISIBILITY)) {
                this.error("Cannot reduce the visibility of the overridden method " + inherited.getSimpleSignature(), sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility", new String[0]);
                continue;
            }
            if (details.contains((Object)IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH)) {
                if (exceptionMismatch == null) {
                    exceptionMismatch = new ArrayList<IResolvedOperation>(allInherited.size());
                }
                exceptionMismatch.add(inherited);
                continue;
            }
            if (details.contains((Object)IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH)) {
                this.error("The return type is incompatible with " + inherited.getSimpleSignature(), sourceElement, this.returnTypeFeature(sourceElement, resolved), "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                continue;
            }
            if (!details.contains((Object)IOverrideCheckResult.OverrideCheckDetails.SYNCHRONIZED_MISMATCH)) continue;
            this.warning("The overridden method is synchronized, the current one is not synchronized.", sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.missing_synchronized", new String[0]);
        }
        if (exceptionMismatch != null) {
            this.createExceptionMismatchError(resolved, sourceElement, exceptionMismatch);
        }
    }

    protected void createExceptionMismatchError(IResolvedOperation operation, EObject sourceElement, List<IResolvedOperation> exceptionMismatch) {
        List<LightweightTypeReference> exceptions = operation.getIllegallyDeclaredExceptions();
        StringBuilder suffixMessage = new StringBuilder();
        suffixMessage.append(" not compatible with the throws clause in ");
        int i = 0;
        while (i < exceptionMismatch.size()) {
            if (i != 0) {
                if (i != exceptionMismatch.size() - 1) {
                    suffixMessage.append(", ");
                } else {
                    suffixMessage.append(" and ");
                }
            }
            IResolvedOperation resolvedOperation = exceptionMismatch.get(i);
            suffixMessage.append(this.getDeclaratorName(resolvedOperation));
            suffixMessage.append('.');
            suffixMessage.append(exceptionMismatch.get(i).getSimpleSignature());
            ++i;
        }
        List<LightweightTypeReference> resolvedExceptions = operation.getResolvedExceptions();
        JvmOperation sourceOperation = operation.getDeclaration();
        for (LightweightTypeReference exception : exceptions) {
            StringBuilder message = new StringBuilder(100);
            message.append("The declared exception ");
            message.append(exception.getHumanReadableName());
            message.append(" is");
            message.append((CharSequence)suffixMessage);
            int exceptionIndex = resolvedExceptions.indexOf(exception);
            JvmTypeReference exceptionType = (JvmTypeReference)sourceOperation.getExceptions().get(exceptionIndex);
            EObject sourceExceptionType = this.associations.getPrimarySourceElement((EObject)exceptionType);
            EStructuralFeature feature = null;
            if (sourceExceptionType != null) {
                feature = sourceExceptionType.eContainingFeature();
            }
            this.error(message.toString(), sourceElement, feature, exceptionIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_throws_clause", new String[0]);
        }
    }

    protected String typeLabel(JvmExecutable executable) {
        if (executable instanceof JvmOperation) {
            return "method";
        }
        if (executable instanceof JvmConstructor) {
            return "constructor";
        }
        return "?";
    }

    protected String getDeclaratorName(JvmFeature feature) {
        JvmDeclaredType declarator = feature.getDeclaringType();
        if (declarator.isLocal()) {
            return "new " + ((JvmTypeReference)Iterables.getLast((Iterable)declarator.getSuperTypes())).getType().getSimpleName() + "(){}";
        }
        return declarator.getSimpleName();
    }

    protected String getDeclaratorName(IResolvedOperation resolved) {
        return this.getDeclaratorName((JvmFeature)resolved.getDeclaration());
    }

    protected EStructuralFeature returnTypeFeature(EObject member, IResolvedOperation resolved) {
        JvmOperation operation = resolved.getDeclaration();
        JvmTypeReference returnType = operation.getReturnType();
        EObject sourceReturnType = this.associations.getPrimarySourceElement((EObject)returnType);
        if (sourceReturnType != null) {
            return sourceReturnType.eContainingFeature();
        }
        return null;
    }

    protected GeneratorConfig getGeneratorConfig(EObject element) {
        GeneratorConfig result = (GeneratorConfig)this.getContext().get(GeneratorConfig.class);
        if (result == null) {
            result = this.generatorConfigProvider.get(element);
            this.getContext().put(GeneratorConfig.class, result);
        }
        return result;
    }

    protected void handleExceptionDuringValidation(Runnable code) {
        try {
            code.run();
        }
        catch (Throwable e) {
            this.handleExceptionDuringValidation(e);
        }
    }
}

