/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_Win32DrawingSurfaceInfo")
public class JAWTWin32DrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HWND;
    public static final int HBITMAP;
    public static final int PBITS;
    public static final int HDC;
    public static final int HPALETTE;

    public JAWTWin32DrawingSurfaceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), JAWTWin32DrawingSurfaceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HWND")
    public long hwnd() {
        return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
    }

    @NativeType(value="HBITMAP")
    public long hbitmap() {
        return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pbits(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
    }

    @NativeType(value="HDC")
    public long hdc() {
        return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
    }

    @NativeType(value="HPALETTE")
    public long hpalette() {
        return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
    }

    public static JAWTWin32DrawingSurfaceInfo create(long address) {
        return (JAWTWin32DrawingSurfaceInfo)JAWTWin32DrawingSurfaceInfo.wrap(JAWTWin32DrawingSurfaceInfo.class, (long)address);
    }

    @Nullable
    public static JAWTWin32DrawingSurfaceInfo createSafe(long address) {
        return address == 0L ? null : (JAWTWin32DrawingSurfaceInfo)JAWTWin32DrawingSurfaceInfo.wrap(JAWTWin32DrawingSurfaceInfo.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)JAWTWin32DrawingSurfaceInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)JAWTWin32DrawingSurfaceInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HWND));
    }

    public static long nhbitmap(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HBITMAP));
    }

    public static ByteBuffer npbits(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PBITS)), (int)capacity);
    }

    public static long nhdc(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HDC));
    }

    public static long nhpalette(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HPALETTE));
    }

    static {
        Struct.Layout layout = JAWTWin32DrawingSurfaceInfo.__struct((Struct.Member[])new Struct.Member[]{JAWTWin32DrawingSurfaceInfo.__union((Struct.Member[])new Struct.Member[]{JAWTWin32DrawingSurfaceInfo.__member((int)POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member((int)POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member((int)POINTER_SIZE)}), JAWTWin32DrawingSurfaceInfo.__member((int)POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HWND = layout.offsetof(1);
        HBITMAP = layout.offsetof(2);
        PBITS = layout.offsetof(3);
        HDC = layout.offsetof(4);
        HPALETTE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<JAWTWin32DrawingSurfaceInfo, Buffer> {
        private static final JAWTWin32DrawingSurfaceInfo ELEMENT_FACTORY = JAWTWin32DrawingSurfaceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected JAWTWin32DrawingSurfaceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HWND")
        public long hwnd() {
            return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
        }

        @NativeType(value="HBITMAP")
        public long hbitmap() {
            return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pbits(int capacity) {
            return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
        }

        @NativeType(value="HDC")
        public long hdc() {
            return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
        }

        @NativeType(value="HPALETTE")
        public long hpalette() {
            return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
        }
    }
}

