/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOpInfoSymbol1;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LLVMOpInfo1")
public class LLVMOpInfo1
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDSYMBOL;
    public static final int SUBTRACTSYMBOL;
    public static final int VALUE;
    public static final int VARIANTKIND;

    public LLVMOpInfo1(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOpInfo1.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct LLVMOpInfoSymbol1")
    public LLVMOpInfoSymbol1 AddSymbol() {
        return LLVMOpInfo1.nAddSymbol(this.address());
    }

    @NativeType(value="struct LLVMOpInfoSymbol1")
    public LLVMOpInfoSymbol1 SubtractSymbol() {
        return LLVMOpInfo1.nSubtractSymbol(this.address());
    }

    @NativeType(value="uint64_t")
    public long Value() {
        return LLVMOpInfo1.nValue(this.address());
    }

    @NativeType(value="uint64_t")
    public long VariantKind() {
        return LLVMOpInfo1.nVariantKind(this.address());
    }

    public LLVMOpInfo1 AddSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
        LLVMOpInfo1.nAddSymbol(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 AddSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
        consumer.accept(this.AddSymbol());
        return this;
    }

    public LLVMOpInfo1 SubtractSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
        LLVMOpInfo1.nSubtractSymbol(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 SubtractSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
        consumer.accept(this.SubtractSymbol());
        return this;
    }

    public LLVMOpInfo1 Value(@NativeType(value="uint64_t") long value) {
        LLVMOpInfo1.nValue(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 VariantKind(@NativeType(value="uint64_t") long value) {
        LLVMOpInfo1.nVariantKind(this.address(), value);
        return this;
    }

    public LLVMOpInfo1 set(LLVMOpInfoSymbol1 AddSymbol, LLVMOpInfoSymbol1 SubtractSymbol, long Value, long VariantKind) {
        this.AddSymbol(AddSymbol);
        this.SubtractSymbol(SubtractSymbol);
        this.Value(Value);
        this.VariantKind(VariantKind);
        return this;
    }

    public LLVMOpInfo1 set(LLVMOpInfo1 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOpInfo1 malloc() {
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMOpInfo1 calloc() {
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMOpInfo1 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMOpInfo1 create(long address) {
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)address);
    }

    @Nullable
    public static LLVMOpInfo1 createSafe(long address) {
        return address == 0L ? null : (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMOpInfo1.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOpInfo1.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static LLVMOpInfo1 mallocStack() {
        return LLVMOpInfo1.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfo1 callocStack() {
        return LLVMOpInfo1.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfo1 mallocStack(MemoryStack stack) {
        return LLVMOpInfo1.malloc(stack);
    }

    @Deprecated
    public static LLVMOpInfo1 callocStack(MemoryStack stack) {
        return LLVMOpInfo1.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LLVMOpInfo1.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LLVMOpInfo1.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfo1.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfo1.calloc(capacity, stack);
    }

    public static LLVMOpInfo1 malloc(MemoryStack stack) {
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOpInfo1 calloc(MemoryStack stack) {
        return (LLVMOpInfo1)LLVMOpInfo1.wrap(LLVMOpInfo1.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOpInfo1.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static LLVMOpInfoSymbol1 nAddSymbol(long struct) {
        return LLVMOpInfoSymbol1.create(struct + (long)ADDSYMBOL);
    }

    public static LLVMOpInfoSymbol1 nSubtractSymbol(long struct) {
        return LLVMOpInfoSymbol1.create(struct + (long)SUBTRACTSYMBOL);
    }

    public static long nValue(long struct) {
        return UNSAFE.getLong(null, struct + (long)VALUE);
    }

    public static long nVariantKind(long struct) {
        return UNSAFE.getLong(null, struct + (long)VARIANTKIND);
    }

    public static void nAddSymbol(long struct, LLVMOpInfoSymbol1 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ADDSYMBOL), (long)LLVMOpInfoSymbol1.SIZEOF);
    }

    public static void nSubtractSymbol(long struct, LLVMOpInfoSymbol1 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBTRACTSYMBOL), (long)LLVMOpInfoSymbol1.SIZEOF);
    }

    public static void nValue(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VALUE, value);
    }

    public static void nVariantKind(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VARIANTKIND, value);
    }

    static {
        Struct.Layout layout = LLVMOpInfo1.__struct((Struct.Member[])new Struct.Member[]{LLVMOpInfo1.__member((int)LLVMOpInfoSymbol1.SIZEOF, (int)LLVMOpInfoSymbol1.ALIGNOF), LLVMOpInfo1.__member((int)LLVMOpInfoSymbol1.SIZEOF, (int)LLVMOpInfoSymbol1.ALIGNOF), LLVMOpInfo1.__member((int)8), LLVMOpInfo1.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDSYMBOL = layout.offsetof(0);
        SUBTRACTSYMBOL = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        VARIANTKIND = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LLVMOpInfo1, Buffer>
    implements NativeResource {
        private static final LLVMOpInfo1 ELEMENT_FACTORY = LLVMOpInfo1.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOpInfo1 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct LLVMOpInfoSymbol1")
        public LLVMOpInfoSymbol1 AddSymbol() {
            return LLVMOpInfo1.nAddSymbol(this.address());
        }

        @NativeType(value="struct LLVMOpInfoSymbol1")
        public LLVMOpInfoSymbol1 SubtractSymbol() {
            return LLVMOpInfo1.nSubtractSymbol(this.address());
        }

        @NativeType(value="uint64_t")
        public long Value() {
            return LLVMOpInfo1.nValue(this.address());
        }

        @NativeType(value="uint64_t")
        public long VariantKind() {
            return LLVMOpInfo1.nVariantKind(this.address());
        }

        public Buffer AddSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
            LLVMOpInfo1.nAddSymbol(this.address(), value);
            return this;
        }

        public Buffer AddSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
            consumer.accept(this.AddSymbol());
            return this;
        }

        public Buffer SubtractSymbol(@NativeType(value="struct LLVMOpInfoSymbol1") LLVMOpInfoSymbol1 value) {
            LLVMOpInfo1.nSubtractSymbol(this.address(), value);
            return this;
        }

        public Buffer SubtractSymbol(Consumer<LLVMOpInfoSymbol1> consumer) {
            consumer.accept(this.SubtractSymbol());
            return this;
        }

        public Buffer Value(@NativeType(value="uint64_t") long value) {
            LLVMOpInfo1.nValue(this.address(), value);
            return this;
        }

        public Buffer VariantKind(@NativeType(value="uint64_t") long value) {
            LLVMOpInfo1.nVariantKind(this.address(), value);
            return this;
        }
    }
}

