/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMObject {
    protected LLVMObject() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMObjectFileRef")
    public static long LLVMCreateObjectFile(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.CreateObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)MemBuf);
        }
        return JNI.invokePP((long)MemBuf, (long)__functionAddress);
    }

    public static void LLVMDisposeObjectFile(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.DisposeObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        JNI.invokePV((long)ObjectFile, (long)__functionAddress);
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMGetSections(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSections;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        return JNI.invokePP((long)ObjectFile, (long)__functionAddress);
    }

    public static void LLVMDisposeSectionIterator(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSectionIterator;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSectionIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.IsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)ObjectFile, (long)SI, (long)__functionAddress) != 0;
    }

    public static void LLVMMoveToNextSection(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSection;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static void LLVMMoveToContainingSection(@NativeType(value="LLVMSectionIteratorRef") long Sect, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.MoveToContainingSection;
        if (Checks.CHECKS) {
            Checks.check((long)Sect);
            Checks.check((long)Sym);
        }
        JNI.invokePPV((long)Sect, (long)Sym, (long)__functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetSymbols(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSymbols;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        return JNI.invokePP((long)ObjectFile, (long)__functionAddress);
    }

    public static void LLVMDisposeSymbolIterator(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSymbolIterator;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSymbolIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.IsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)ObjectFile, (long)SI, (long)__functionAddress) != 0;
    }

    public static void LLVMMoveToNextSymbol(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static long nLLVMGetSectionName(long SI) {
        long __functionAddress = Functions.GetSectionName;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionName(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionName(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionSize(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionSize;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    public static long nLLVMGetSectionContents(long SI) {
        long __functionAddress = Functions.GetSectionContents;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionContents(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionContents(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionAddress(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionAddress;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetSectionContainsSymbol(@NativeType(value="LLVMSectionIteratorRef") long SI, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.GetSectionContainsSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
            Checks.check((long)Sym);
        }
        return JNI.invokePPI((long)SI, (long)Sym, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMRelocationIteratorRef")
    public static long LLVMGetRelocations(@NativeType(value="LLVMSectionIteratorRef") long Section) {
        long __functionAddress = Functions.GetRelocations;
        if (Checks.CHECKS) {
            Checks.check((long)Section);
        }
        return JNI.invokePP((long)Section, (long)__functionAddress);
    }

    public static void LLVMDisposeRelocationIterator(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.DisposeRelocationIterator;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        JNI.invokePV((long)RI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsRelocationIteratorAtEnd(@NativeType(value="LLVMSectionIteratorRef") long Section, @NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.IsRelocationIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)Section);
            Checks.check((long)RI);
        }
        return JNI.invokePPI((long)Section, (long)RI, (long)__functionAddress) != 0;
    }

    public static void LLVMMoveToNextRelocation(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.MoveToNextRelocation;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        JNI.invokePV((long)RI, (long)__functionAddress);
    }

    public static long nLLVMGetSymbolName(long SI) {
        long __functionAddress = Functions.GetSymbolName;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSymbolName(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSymbolName(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolAddress(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolAddress;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolSize(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolSize;
        if (Checks.CHECKS) {
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationOffset(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationOffset;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        return JNI.invokePJ((long)RI, (long)__functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetRelocationSymbol(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationType(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationType;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        return JNI.invokePJ((long)RI, (long)__functionAddress);
    }

    public static long nLLVMGetRelocationTypeName(long RI) {
        long __functionAddress = Functions.GetRelocationTypeName;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationTypeName(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationTypeName(RI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetRelocationValueString(long RI) {
        long __functionAddress = Functions.GetRelocationValueString;
        if (Checks.CHECKS) {
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationValueString(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationValueString(RI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static final class Functions {
        public static final long CreateObjectFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateObjectFile");
        public static final long DisposeObjectFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeObjectFile");
        public static final long GetSections = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSections");
        public static final long DisposeSectionIterator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeSectionIterator");
        public static final long IsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIsSectionIteratorAtEnd");
        public static final long MoveToNextSection = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMMoveToNextSection");
        public static final long MoveToContainingSection = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMMoveToContainingSection");
        public static final long GetSymbols = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSymbols");
        public static final long DisposeSymbolIterator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeSymbolIterator");
        public static final long IsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIsSymbolIteratorAtEnd");
        public static final long MoveToNextSymbol = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMMoveToNextSymbol");
        public static final long GetSectionName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSectionName");
        public static final long GetSectionSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSectionSize");
        public static final long GetSectionContents = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSectionContents");
        public static final long GetSectionAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSectionAddress");
        public static final long GetSectionContainsSymbol = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSectionContainsSymbol");
        public static final long GetRelocations = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocations");
        public static final long DisposeRelocationIterator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeRelocationIterator");
        public static final long IsRelocationIteratorAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIsRelocationIteratorAtEnd");
        public static final long MoveToNextRelocation = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMMoveToNextRelocation");
        public static final long GetSymbolName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSymbolName");
        public static final long GetSymbolAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSymbolAddress");
        public static final long GetSymbolSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSymbolSize");
        public static final long GetRelocationOffset = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocationOffset");
        public static final long GetRelocationSymbol = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocationSymbol");
        public static final long GetRelocationType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocationType");
        public static final long GetRelocationTypeName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocationTypeName");
        public static final long GetRelocationValueString = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetRelocationValueString");

        private Functions() {
        }
    }
}

