/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineCompilerControlCreateInfoAMD;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfo;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkSubpassShadingPipelineCreateInfoHUAWEI;

public class VkComputePipelineCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int LAYOUT;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    public VkComputePipelineCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkComputePipelineCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkComputePipelineCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkComputePipelineCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineCreateFlags")
    public int flags() {
        return VkComputePipelineCreateInfo.nflags(this.address());
    }

    public VkPipelineShaderStageCreateInfo stage() {
        return VkComputePipelineCreateInfo.nstage(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkComputePipelineCreateInfo.nlayout(this.address());
    }

    @NativeType(value="VkPipeline")
    public long basePipelineHandle() {
        return VkComputePipelineCreateInfo.nbasePipelineHandle(this.address());
    }

    @NativeType(value="int32_t")
    public int basePipelineIndex() {
        return VkComputePipelineCreateInfo.nbasePipelineIndex(this.address());
    }

    public VkComputePipelineCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkComputePipelineCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo sType$Default() {
        return this.sType(29);
    }

    public VkComputePipelineCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkComputePipelineCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo pNext(VkPipelineCompilerControlCreateInfoAMD value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkComputePipelineCreateInfo pNext(VkPipelineCreationFeedbackCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkComputePipelineCreateInfo pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkComputePipelineCreateInfo pNext(VkSubpassShadingPipelineCreateInfoHUAWEI value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkComputePipelineCreateInfo flags(@NativeType(value="VkPipelineCreateFlags") int value) {
        VkComputePipelineCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo stage(VkPipelineShaderStageCreateInfo value) {
        VkComputePipelineCreateInfo.nstage(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo stage(Consumer<VkPipelineShaderStageCreateInfo> consumer) {
        consumer.accept(this.stage());
        return this;
    }

    public VkComputePipelineCreateInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkComputePipelineCreateInfo.nlayout(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo basePipelineHandle(@NativeType(value="VkPipeline") long value) {
        VkComputePipelineCreateInfo.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo basePipelineIndex(@NativeType(value="int32_t") int value) {
        VkComputePipelineCreateInfo.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkComputePipelineCreateInfo set(int sType, long pNext, int flags, VkPipelineShaderStageCreateInfo stage, long layout, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.layout(layout);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkComputePipelineCreateInfo set(VkComputePipelineCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkComputePipelineCreateInfo malloc() {
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkComputePipelineCreateInfo calloc() {
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkComputePipelineCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkComputePipelineCreateInfo create(long address) {
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkComputePipelineCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkComputePipelineCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkComputePipelineCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkComputePipelineCreateInfo mallocStack() {
        return VkComputePipelineCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComputePipelineCreateInfo callocStack() {
        return VkComputePipelineCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComputePipelineCreateInfo mallocStack(MemoryStack stack) {
        return VkComputePipelineCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkComputePipelineCreateInfo callocStack(MemoryStack stack) {
        return VkComputePipelineCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkComputePipelineCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkComputePipelineCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkComputePipelineCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkComputePipelineCreateInfo.calloc(capacity, stack);
    }

    public static VkComputePipelineCreateInfo malloc(MemoryStack stack) {
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkComputePipelineCreateInfo calloc(MemoryStack stack) {
        return (VkComputePipelineCreateInfo)VkComputePipelineCreateInfo.wrap(VkComputePipelineCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkComputePipelineCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkPipelineShaderStageCreateInfo nstage(long struct) {
        return VkPipelineShaderStageCreateInfo.create(struct + (long)STAGE);
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static long nbasePipelineHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nstage(long struct, VkPipelineShaderStageCreateInfo value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STAGE), (long)VkPipelineShaderStageCreateInfo.SIZEOF);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        VkPipelineShaderStageCreateInfo.validate(struct + (long)STAGE);
    }

    static {
        Struct.Layout layout = VkComputePipelineCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkComputePipelineCreateInfo.__member((int)4), VkComputePipelineCreateInfo.__member((int)POINTER_SIZE), VkComputePipelineCreateInfo.__member((int)4), VkComputePipelineCreateInfo.__member((int)VkPipelineShaderStageCreateInfo.SIZEOF, (int)VkPipelineShaderStageCreateInfo.ALIGNOF), VkComputePipelineCreateInfo.__member((int)8), VkComputePipelineCreateInfo.__member((int)8), VkComputePipelineCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        LAYOUT = layout.offsetof(4);
        BASEPIPELINEHANDLE = layout.offsetof(5);
        BASEPIPELINEINDEX = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkComputePipelineCreateInfo, Buffer>
    implements NativeResource {
        private static final VkComputePipelineCreateInfo ELEMENT_FACTORY = VkComputePipelineCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkComputePipelineCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkComputePipelineCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkComputePipelineCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineCreateFlags")
        public int flags() {
            return VkComputePipelineCreateInfo.nflags(this.address());
        }

        public VkPipelineShaderStageCreateInfo stage() {
            return VkComputePipelineCreateInfo.nstage(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkComputePipelineCreateInfo.nlayout(this.address());
        }

        @NativeType(value="VkPipeline")
        public long basePipelineHandle() {
            return VkComputePipelineCreateInfo.nbasePipelineHandle(this.address());
        }

        @NativeType(value="int32_t")
        public int basePipelineIndex() {
            return VkComputePipelineCreateInfo.nbasePipelineIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkComputePipelineCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(29);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkComputePipelineCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineCompilerControlCreateInfoAMD value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSubpassShadingPipelineCreateInfoHUAWEI value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineCreateFlags") int value) {
            VkComputePipelineCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(VkPipelineShaderStageCreateInfo value) {
            VkComputePipelineCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer stage(Consumer<VkPipelineShaderStageCreateInfo> consumer) {
            consumer.accept(this.stage());
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkComputePipelineCreateInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(@NativeType(value="VkPipeline") long value) {
            VkComputePipelineCreateInfo.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(@NativeType(value="int32_t") int value) {
            VkComputePipelineCreateInfo.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

