/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPrivateDataSlotCreateInfo;

public class EXTPrivateData {
    public static final int VK_EXT_PRIVATE_DATA_SPEC_VERSION = 1;
    public static final String VK_EXT_PRIVATE_DATA_EXTENSION_NAME = "VK_EXT_private_data";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT = 1000295000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT = 1000295001;
    public static final int VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT = 1000295002;
    public static final int VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT = 1000295000;

    protected EXTPrivateData() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreatePrivateDataSlotEXT(VkDevice device, long pCreateInfo, long pAllocator, long pPrivateDataSlot) {
        long __functionAddress = device.getCapabilities().vkCreatePrivateDataSlotEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pPrivateDataSlot, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreatePrivateDataSlotEXT(VkDevice device, @NativeType(value="VkPrivateDataSlotCreateInfo const *") VkPrivateDataSlotCreateInfo pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPrivateDataSlot *") LongBuffer pPrivateDataSlot) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPrivateDataSlot, (int)1);
        }
        return EXTPrivateData.nvkCreatePrivateDataSlotEXT(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pPrivateDataSlot));
    }

    public static void nvkDestroyPrivateDataSlotEXT(VkDevice device, long privateDataSlot, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyPrivateDataSlotEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)device.address(), (long)privateDataSlot, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyPrivateDataSlotEXT(VkDevice device, @NativeType(value="VkPrivateDataSlot") long privateDataSlot, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        EXTPrivateData.nvkDestroyPrivateDataSlotEXT(device, privateDataSlot, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    @NativeType(value="VkResult")
    public static int vkSetPrivateDataEXT(VkDevice device, @NativeType(value="VkObjectType") int objectType, @NativeType(value="uint64_t") long objectHandle, @NativeType(value="VkPrivateDataSlot") long privateDataSlot, @NativeType(value="uint64_t") long data) {
        long __functionAddress = device.getCapabilities().vkSetPrivateDataEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJJJI((long)device.address(), (int)objectType, (long)objectHandle, (long)privateDataSlot, (long)data, (long)__functionAddress);
    }

    public static void nvkGetPrivateDataEXT(VkDevice device, int objectType, long objectHandle, long privateDataSlot, long pData) {
        long __functionAddress = device.getCapabilities().vkGetPrivateDataEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJJPV((long)device.address(), (int)objectType, (long)objectHandle, (long)privateDataSlot, (long)pData, (long)__functionAddress);
    }

    public static void vkGetPrivateDataEXT(VkDevice device, @NativeType(value="VkObjectType") int objectType, @NativeType(value="uint64_t") long objectHandle, @NativeType(value="VkPrivateDataSlot") long privateDataSlot, @NativeType(value="uint64_t *") LongBuffer pData) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pData, (int)1);
        }
        EXTPrivateData.nvkGetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, MemoryUtil.memAddress((LongBuffer)pData));
    }

    @NativeType(value="VkResult")
    public static int vkCreatePrivateDataSlotEXT(VkDevice device, @NativeType(value="VkPrivateDataSlotCreateInfo const *") VkPrivateDataSlotCreateInfo pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPrivateDataSlot *") long[] pPrivateDataSlot) {
        long __functionAddress = device.getCapabilities().vkCreatePrivateDataSlotEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pPrivateDataSlot, (int)1);
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pPrivateDataSlot, (long)__functionAddress);
    }

    public static void vkGetPrivateDataEXT(VkDevice device, @NativeType(value="VkObjectType") int objectType, @NativeType(value="uint64_t") long objectHandle, @NativeType(value="VkPrivateDataSlot") long privateDataSlot, @NativeType(value="uint64_t *") long[] pData) {
        long __functionAddress = device.getCapabilities().vkGetPrivateDataEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pData, (int)1);
        }
        JNI.callPJJPV((long)device.address(), (int)objectType, (long)objectHandle, (long)privateDataSlot, (long[])pData, (long)__functionAddress);
    }
}

