/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrApplicationInfo;
import org.lwjgl.openxr.XrDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInstanceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;
    public static final int APPLICATIONINFO;
    public static final int ENABLEDAPILAYERCOUNT;
    public static final int ENABLEDAPILAYERNAMES;
    public static final int ENABLEDEXTENSIONCOUNT;
    public static final int ENABLEDEXTENSIONNAMES;

    public XrInstanceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInstanceCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInstanceCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInstanceCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrInstanceCreateFlags")
    public long createFlags() {
        return XrInstanceCreateInfo.ncreateFlags(this.address());
    }

    public XrApplicationInfo applicationInfo() {
        return XrInstanceCreateInfo.napplicationInfo(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledApiLayerCount() {
        return XrInstanceCreateInfo.nenabledApiLayerCount(this.address());
    }

    @Nullable
    @NativeType(value="char const * const *")
    public PointerBuffer enabledApiLayerNames() {
        return XrInstanceCreateInfo.nenabledApiLayerNames(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledExtensionCount() {
        return XrInstanceCreateInfo.nenabledExtensionCount(this.address());
    }

    @Nullable
    @NativeType(value="char const * const *")
    public PointerBuffer enabledExtensionNames() {
        return XrInstanceCreateInfo.nenabledExtensionNames(this.address());
    }

    public XrInstanceCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrInstanceCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo type$Default() {
        return this.type(3);
    }

    public XrInstanceCreateInfo next(@NativeType(value="void const *") long value) {
        XrInstanceCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo next(XrDebugUtilsMessengerCreateInfoEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrInstanceCreateInfo createFlags(@NativeType(value="XrInstanceCreateFlags") long value) {
        XrInstanceCreateInfo.ncreateFlags(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo applicationInfo(XrApplicationInfo value) {
        XrInstanceCreateInfo.napplicationInfo(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo applicationInfo(Consumer<XrApplicationInfo> consumer) {
        consumer.accept(this.applicationInfo());
        return this;
    }

    public XrInstanceCreateInfo enabledApiLayerNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
        XrInstanceCreateInfo.nenabledApiLayerNames(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo enabledExtensionNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
        XrInstanceCreateInfo.nenabledExtensionNames(this.address(), value);
        return this;
    }

    public XrInstanceCreateInfo set(int type, long next, long createFlags, XrApplicationInfo applicationInfo, @Nullable PointerBuffer enabledApiLayerNames, @Nullable PointerBuffer enabledExtensionNames) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        this.applicationInfo(applicationInfo);
        this.enabledApiLayerNames(enabledApiLayerNames);
        this.enabledExtensionNames(enabledExtensionNames);
        return this;
    }

    public XrInstanceCreateInfo set(XrInstanceCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInstanceCreateInfo malloc() {
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrInstanceCreateInfo calloc() {
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrInstanceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrInstanceCreateInfo create(long address) {
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)address);
    }

    @Nullable
    public static XrInstanceCreateInfo createSafe(long address) {
        return address == 0L ? null : (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrInstanceCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInstanceCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrInstanceCreateInfo malloc(MemoryStack stack) {
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInstanceCreateInfo calloc(MemoryStack stack) {
        return (XrInstanceCreateInfo)XrInstanceCreateInfo.wrap(XrInstanceCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrInstanceCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static XrApplicationInfo napplicationInfo(long struct) {
        return XrApplicationInfo.create(struct + (long)APPLICATIONINFO);
    }

    public static int nenabledApiLayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDAPILAYERCOUNT);
    }

    @Nullable
    public static PointerBuffer nenabledApiLayerNames(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)ENABLEDAPILAYERNAMES)), (int)XrInstanceCreateInfo.nenabledApiLayerCount(struct));
    }

    public static int nenabledExtensionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDEXTENSIONCOUNT);
    }

    @Nullable
    public static PointerBuffer nenabledExtensionNames(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)ENABLEDEXTENSIONNAMES)), (int)XrInstanceCreateInfo.nenabledExtensionCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void napplicationInfo(long struct, XrApplicationInfo value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)APPLICATIONINFO), (long)XrApplicationInfo.SIZEOF);
    }

    public static void nenabledApiLayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDAPILAYERCOUNT, value);
    }

    public static void nenabledApiLayerNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ENABLEDAPILAYERNAMES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        XrInstanceCreateInfo.nenabledApiLayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nenabledExtensionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDEXTENSIONCOUNT, value);
    }

    public static void nenabledExtensionNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ENABLEDEXTENSIONNAMES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        XrInstanceCreateInfo.nenabledExtensionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (XrInstanceCreateInfo.nenabledApiLayerCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ENABLEDAPILAYERNAMES)));
        }
        if (XrInstanceCreateInfo.nenabledExtensionCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ENABLEDEXTENSIONNAMES)));
        }
    }

    static {
        Struct.Layout layout = XrInstanceCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrInstanceCreateInfo.__member((int)4), XrInstanceCreateInfo.__member((int)POINTER_SIZE), XrInstanceCreateInfo.__member((int)8), XrInstanceCreateInfo.__member((int)XrApplicationInfo.SIZEOF, (int)XrApplicationInfo.ALIGNOF), XrInstanceCreateInfo.__member((int)4), XrInstanceCreateInfo.__member((int)POINTER_SIZE), XrInstanceCreateInfo.__member((int)4), XrInstanceCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        APPLICATIONINFO = layout.offsetof(3);
        ENABLEDAPILAYERCOUNT = layout.offsetof(4);
        ENABLEDAPILAYERNAMES = layout.offsetof(5);
        ENABLEDEXTENSIONCOUNT = layout.offsetof(6);
        ENABLEDEXTENSIONNAMES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrInstanceCreateInfo, Buffer>
    implements NativeResource {
        private static final XrInstanceCreateInfo ELEMENT_FACTORY = XrInstanceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrInstanceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInstanceCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInstanceCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrInstanceCreateFlags")
        public long createFlags() {
            return XrInstanceCreateInfo.ncreateFlags(this.address());
        }

        public XrApplicationInfo applicationInfo() {
            return XrInstanceCreateInfo.napplicationInfo(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledApiLayerCount() {
            return XrInstanceCreateInfo.nenabledApiLayerCount(this.address());
        }

        @Nullable
        @NativeType(value="char const * const *")
        public PointerBuffer enabledApiLayerNames() {
            return XrInstanceCreateInfo.nenabledApiLayerNames(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledExtensionCount() {
            return XrInstanceCreateInfo.nenabledExtensionCount(this.address());
        }

        @Nullable
        @NativeType(value="char const * const *")
        public PointerBuffer enabledExtensionNames() {
            return XrInstanceCreateInfo.nenabledExtensionNames(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInstanceCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(3);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInstanceCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrDebugUtilsMessengerCreateInfoEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer createFlags(@NativeType(value="XrInstanceCreateFlags") long value) {
            XrInstanceCreateInfo.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer applicationInfo(XrApplicationInfo value) {
            XrInstanceCreateInfo.napplicationInfo(this.address(), value);
            return this;
        }

        public Buffer applicationInfo(Consumer<XrApplicationInfo> consumer) {
            consumer.accept(this.applicationInfo());
            return this;
        }

        public Buffer enabledApiLayerNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
            XrInstanceCreateInfo.nenabledApiLayerNames(this.address(), value);
            return this;
        }

        public Buffer enabledExtensionNames(@Nullable @NativeType(value="char const * const *") PointerBuffer value) {
            XrInstanceCreateInfo.nenabledExtensionNames(this.address(), value);
            return this;
        }
    }
}

