/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPassthroughLayerFB;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerPassthroughFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int SPACE;
    public static final int LAYERHANDLE;

    public XrCompositionLayerPassthroughFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerPassthroughFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerPassthroughFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerPassthroughFB.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long flags() {
        return XrCompositionLayerPassthroughFB.nflags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerPassthroughFB.nspace(this.address());
    }

    @NativeType(value="XrPassthroughLayerFB")
    public long layerHandle() {
        return XrCompositionLayerPassthroughFB.nlayerHandle(this.address());
    }

    public XrCompositionLayerPassthroughFB type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerPassthroughFB.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB type$Default() {
        return this.type(1000118003);
    }

    public XrCompositionLayerPassthroughFB next(@NativeType(value="void const *") long value) {
        XrCompositionLayerPassthroughFB.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB flags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerPassthroughFB.nflags(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB space(XrSpace value) {
        XrCompositionLayerPassthroughFB.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB layerHandle(XrPassthroughLayerFB value) {
        XrCompositionLayerPassthroughFB.nlayerHandle(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB set(int type, long next, long flags, XrSpace space, XrPassthroughLayerFB layerHandle) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.space(space);
        this.layerHandle(layerHandle);
        return this;
    }

    public XrCompositionLayerPassthroughFB set(XrCompositionLayerPassthroughFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerPassthroughFB malloc() {
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCompositionLayerPassthroughFB calloc() {
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCompositionLayerPassthroughFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCompositionLayerPassthroughFB create(long address) {
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)address);
    }

    @Nullable
    public static XrCompositionLayerPassthroughFB createSafe(long address) {
        return address == 0L ? null : (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCompositionLayerPassthroughFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerPassthroughFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrCompositionLayerPassthroughFB malloc(MemoryStack stack) {
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerPassthroughFB calloc(MemoryStack stack) {
        return (XrCompositionLayerPassthroughFB)XrCompositionLayerPassthroughFB.wrap(XrCompositionLayerPassthroughFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerPassthroughFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static long nlayerHandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LAYERHANDLE));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nlayerHandle(long struct, XrPassthroughLayerFB value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LAYERHANDLE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)LAYERHANDLE)));
    }

    static {
        Struct.Layout layout = XrCompositionLayerPassthroughFB.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerPassthroughFB.__member((int)4), XrCompositionLayerPassthroughFB.__member((int)POINTER_SIZE), XrCompositionLayerPassthroughFB.__member((int)8), XrCompositionLayerPassthroughFB.__member((int)POINTER_SIZE), XrCompositionLayerPassthroughFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        LAYERHANDLE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerPassthroughFB, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerPassthroughFB ELEMENT_FACTORY = XrCompositionLayerPassthroughFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerPassthroughFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerPassthroughFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerPassthroughFB.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long flags() {
            return XrCompositionLayerPassthroughFB.nflags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerPassthroughFB.nspace(this.address());
        }

        @NativeType(value="XrPassthroughLayerFB")
        public long layerHandle() {
            return XrCompositionLayerPassthroughFB.nlayerHandle(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerPassthroughFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerPassthroughFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerPassthroughFB.nflags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerPassthroughFB.nspace(this.address(), value);
            return this;
        }

        public Buffer layerHandle(XrPassthroughLayerFB value) {
            XrCompositionLayerPassthroughFB.nlayerHandle(this.address(), value);
            return this;
        }
    }
}

