/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrHandJointLocationsEXT;
import org.lwjgl.openxr.XrHandJointsLocateInfoEXT;
import org.lwjgl.openxr.XrHandTrackerCreateInfoEXT;
import org.lwjgl.openxr.XrHandTrackerEXT;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTHandTracking {
    public static final int XR_EXT_hand_tracking_SPEC_VERSION = 4;
    public static final String XR_EXT_HAND_TRACKING_EXTENSION_NAME = "XR_EXT_hand_tracking";
    public static final int XR_OBJECT_TYPE_HAND_TRACKER_EXT = 1000051000;
    public static final int XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT = 1000051000;
    public static final int XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT = 1000051001;
    public static final int XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT = 1000051002;
    public static final int XR_TYPE_HAND_JOINT_LOCATIONS_EXT = 1000051003;
    public static final int XR_TYPE_HAND_JOINT_VELOCITIES_EXT = 1000051004;
    public static final int XR_HAND_LEFT_EXT = 1;
    public static final int XR_HAND_RIGHT_EXT = 2;
    public static final int XR_HAND_JOINT_PALM_EXT = 0;
    public static final int XR_HAND_JOINT_WRIST_EXT = 1;
    public static final int XR_HAND_JOINT_THUMB_METACARPAL_EXT = 2;
    public static final int XR_HAND_JOINT_THUMB_PROXIMAL_EXT = 3;
    public static final int XR_HAND_JOINT_THUMB_DISTAL_EXT = 4;
    public static final int XR_HAND_JOINT_THUMB_TIP_EXT = 5;
    public static final int XR_HAND_JOINT_INDEX_METACARPAL_EXT = 6;
    public static final int XR_HAND_JOINT_INDEX_PROXIMAL_EXT = 7;
    public static final int XR_HAND_JOINT_INDEX_INTERMEDIATE_EXT = 8;
    public static final int XR_HAND_JOINT_INDEX_DISTAL_EXT = 9;
    public static final int XR_HAND_JOINT_INDEX_TIP_EXT = 10;
    public static final int XR_HAND_JOINT_MIDDLE_METACARPAL_EXT = 11;
    public static final int XR_HAND_JOINT_MIDDLE_PROXIMAL_EXT = 12;
    public static final int XR_HAND_JOINT_MIDDLE_INTERMEDIATE_EXT = 13;
    public static final int XR_HAND_JOINT_MIDDLE_DISTAL_EXT = 14;
    public static final int XR_HAND_JOINT_MIDDLE_TIP_EXT = 15;
    public static final int XR_HAND_JOINT_RING_METACARPAL_EXT = 16;
    public static final int XR_HAND_JOINT_RING_PROXIMAL_EXT = 17;
    public static final int XR_HAND_JOINT_RING_INTERMEDIATE_EXT = 18;
    public static final int XR_HAND_JOINT_RING_DISTAL_EXT = 19;
    public static final int XR_HAND_JOINT_RING_TIP_EXT = 20;
    public static final int XR_HAND_JOINT_LITTLE_METACARPAL_EXT = 21;
    public static final int XR_HAND_JOINT_LITTLE_PROXIMAL_EXT = 22;
    public static final int XR_HAND_JOINT_LITTLE_INTERMEDIATE_EXT = 23;
    public static final int XR_HAND_JOINT_LITTLE_DISTAL_EXT = 24;
    public static final int XR_HAND_JOINT_LITTLE_TIP_EXT = 25;
    public static final int XR_HAND_JOINT_SET_DEFAULT_EXT = 0;
    public static final int XR_HAND_JOINT_COUNT_EXT = 26;

    protected EXTHandTracking() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateHandTrackerEXT(XrSession session, long createInfo, long handTracker) {
        long __functionAddress = session.getCapabilities().xrCreateHandTrackerEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)handTracker, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateHandTrackerEXT(XrSession session, @NativeType(value="XrHandTrackerCreateInfoEXT const *") XrHandTrackerCreateInfoEXT createInfo, @NativeType(value="XrHandTrackerEXT *") PointerBuffer handTracker) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)handTracker, (int)1);
        }
        return EXTHandTracking.nxrCreateHandTrackerEXT(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)handTracker));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyHandTrackerEXT(XrHandTrackerEXT handTracker) {
        long __functionAddress = handTracker.getCapabilities().xrDestroyHandTrackerEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)handTracker.address(), (long)__functionAddress);
    }

    public static int nxrLocateHandJointsEXT(XrHandTrackerEXT handTracker, long locateInfo, long locations) {
        long __functionAddress = handTracker.getCapabilities().xrLocateHandJointsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrHandJointsLocateInfoEXT.validate(locateInfo);
        }
        return JNI.callPPPI((long)handTracker.address(), (long)locateInfo, (long)locations, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLocateHandJointsEXT(XrHandTrackerEXT handTracker, @NativeType(value="XrHandJointsLocateInfoEXT const *") XrHandJointsLocateInfoEXT locateInfo, @NativeType(value="XrHandJointLocationsEXT *") XrHandJointLocationsEXT locations) {
        return EXTHandTracking.nxrLocateHandJointsEXT(handTracker, locateInfo.address(), locations.address());
    }
}

