/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMemoryInfo")
public class AIMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURES;
    public static final int MATERIALS;
    public static final int MESHES;
    public static final int NODES;
    public static final int ANIMATIONS;
    public static final int CAMERAS;
    public static final int LIGHTS;
    public static final int TOTAL;

    public AIMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMemoryInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int textures() {
        return AIMemoryInfo.ntextures(this.address());
    }

    @NativeType(value="unsigned int")
    public int materials() {
        return AIMemoryInfo.nmaterials(this.address());
    }

    @NativeType(value="unsigned int")
    public int meshes() {
        return AIMemoryInfo.nmeshes(this.address());
    }

    @NativeType(value="unsigned int")
    public int nodes() {
        return AIMemoryInfo.nnodes(this.address());
    }

    @NativeType(value="unsigned int")
    public int animations() {
        return AIMemoryInfo.nanimations(this.address());
    }

    @NativeType(value="unsigned int")
    public int cameras() {
        return AIMemoryInfo.ncameras(this.address());
    }

    @NativeType(value="unsigned int")
    public int lights() {
        return AIMemoryInfo.nlights(this.address());
    }

    @NativeType(value="unsigned int")
    public int total() {
        return AIMemoryInfo.ntotal(this.address());
    }

    public static AIMemoryInfo malloc() {
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMemoryInfo calloc() {
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMemoryInfo create(long address) {
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)address);
    }

    @Nullable
    public static AIMemoryInfo createSafe(long address) {
        return address == 0L ? null : (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMemoryInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMemoryInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static AIMemoryInfo mallocStack() {
        return AIMemoryInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMemoryInfo callocStack() {
        return AIMemoryInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMemoryInfo mallocStack(MemoryStack stack) {
        return AIMemoryInfo.malloc(stack);
    }

    @Deprecated
    public static AIMemoryInfo callocStack(MemoryStack stack) {
        return AIMemoryInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMemoryInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMemoryInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.calloc(capacity, stack);
    }

    public static AIMemoryInfo malloc(MemoryStack stack) {
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMemoryInfo calloc(MemoryStack stack) {
        return (AIMemoryInfo)AIMemoryInfo.wrap(AIMemoryInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)AIMemoryInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntextures(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTURES);
    }

    public static int nmaterials(long struct) {
        return UNSAFE.getInt(null, struct + (long)MATERIALS);
    }

    public static int nmeshes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MESHES);
    }

    public static int nnodes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODES);
    }

    public static int nanimations(long struct) {
        return UNSAFE.getInt(null, struct + (long)ANIMATIONS);
    }

    public static int ncameras(long struct) {
        return UNSAFE.getInt(null, struct + (long)CAMERAS);
    }

    public static int nlights(long struct) {
        return UNSAFE.getInt(null, struct + (long)LIGHTS);
    }

    public static int ntotal(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = AIMemoryInfo.__struct((Struct.Member[])new Struct.Member[]{AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4), AIMemoryInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURES = layout.offsetof(0);
        MATERIALS = layout.offsetof(1);
        MESHES = layout.offsetof(2);
        NODES = layout.offsetof(3);
        ANIMATIONS = layout.offsetof(4);
        CAMERAS = layout.offsetof(5);
        LIGHTS = layout.offsetof(6);
        TOTAL = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AIMemoryInfo, Buffer>
    implements NativeResource {
        private static final AIMemoryInfo ELEMENT_FACTORY = AIMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int textures() {
            return AIMemoryInfo.ntextures(this.address());
        }

        @NativeType(value="unsigned int")
        public int materials() {
            return AIMemoryInfo.nmaterials(this.address());
        }

        @NativeType(value="unsigned int")
        public int meshes() {
            return AIMemoryInfo.nmeshes(this.address());
        }

        @NativeType(value="unsigned int")
        public int nodes() {
            return AIMemoryInfo.nnodes(this.address());
        }

        @NativeType(value="unsigned int")
        public int animations() {
            return AIMemoryInfo.nanimations(this.address());
        }

        @NativeType(value="unsigned int")
        public int cameras() {
            return AIMemoryInfo.ncameras(this.address());
        }

        @NativeType(value="unsigned int")
        public int lights() {
            return AIMemoryInfo.nlights(this.address());
        }

        @NativeType(value="unsigned int")
        public int total() {
            return AIMemoryInfo.ntotal(this.address());
        }
    }
}

