/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkContext;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_list_view")
public class NkListView
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BEGIN;
    public static final int END;
    public static final int COUNT;
    public static final int TOTAL_HEIGHT;
    public static final int CTX;
    public static final int SCROLL_POINTER;
    public static final int SCROLL_VALUE;

    public NkListView(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkListView.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int begin() {
        return NkListView.nbegin(this.address());
    }

    public int end() {
        return NkListView.nend(this.address());
    }

    public int count() {
        return NkListView.ncount(this.address());
    }

    public static NkListView malloc() {
        return (NkListView)NkListView.wrap(NkListView.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkListView calloc() {
        return (NkListView)NkListView.wrap(NkListView.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkListView create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkListView)NkListView.wrap(NkListView.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkListView create(long address) {
        return (NkListView)NkListView.wrap(NkListView.class, (long)address);
    }

    @Nullable
    public static NkListView createSafe(long address) {
        return address == 0L ? null : (NkListView)NkListView.wrap(NkListView.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkListView.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkListView.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkListView.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkListView.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkListView.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkListView.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkListView.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkListView mallocStack() {
        return NkListView.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkListView callocStack() {
        return NkListView.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkListView mallocStack(MemoryStack stack) {
        return NkListView.malloc(stack);
    }

    @Deprecated
    public static NkListView callocStack(MemoryStack stack) {
        return NkListView.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkListView.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkListView.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkListView.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkListView.calloc(capacity, stack);
    }

    public static NkListView malloc(MemoryStack stack) {
        return (NkListView)NkListView.wrap(NkListView.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkListView calloc(MemoryStack stack) {
        return (NkListView)NkListView.wrap(NkListView.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkListView.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkListView.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nbegin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BEGIN);
    }

    public static int nend(long struct) {
        return UNSAFE.getInt(null, struct + (long)END);
    }

    public static int ncount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    public static int ntotal_height(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTAL_HEIGHT);
    }

    public static NkContext nctx(long struct) {
        return NkContext.create(MemoryUtil.memGetAddress((long)(struct + (long)CTX)));
    }

    public static IntBuffer nscroll_pointer(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SCROLL_POINTER)), (int)capacity);
    }

    public static int nscroll_value(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCROLL_VALUE);
    }

    static {
        Struct.Layout layout = NkListView.__struct((Struct.Member[])new Struct.Member[]{NkListView.__member((int)4), NkListView.__member((int)4), NkListView.__member((int)4), NkListView.__member((int)4), NkListView.__member((int)POINTER_SIZE), NkListView.__member((int)POINTER_SIZE), NkListView.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BEGIN = layout.offsetof(0);
        END = layout.offsetof(1);
        COUNT = layout.offsetof(2);
        TOTAL_HEIGHT = layout.offsetof(3);
        CTX = layout.offsetof(4);
        SCROLL_POINTER = layout.offsetof(5);
        SCROLL_VALUE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkListView, Buffer>
    implements NativeResource {
        private static final NkListView ELEMENT_FACTORY = NkListView.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkListView getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int begin() {
            return NkListView.nbegin(this.address());
        }

        public int end() {
            return NkListView.nend(this.address());
        }

        public int count() {
            return NkListView.ncount(this.address());
        }
    }
}

