/*
 * Decompiled with CFR 0.152.
 */
package lucee.commons.lang;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ConcurrentHashMapAsHashtable<K, V>
extends Hashtable<K, V> {
    private ConcurrentHashMap<K, V> map = new ConcurrentHashMap();

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.map.keys();
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.map.elements();
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized V get(Object key) {
        return this.map.get(key);
    }

    @Override
    protected void rehash() {
    }

    @Override
    public synchronized V put(K key, V value) {
        if (this.size() > 200) {
            this.clear();
        }
        return this.map.put(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized Object clone() {
        ConcurrentHashMapAsHashtable<K, V> newMap = new ConcurrentHashMapAsHashtable<K, V>();
        for (Map.Entry<K, V> e : this.map.entrySet()) {
            newMap.put(e.getKey(), e.getValue());
        }
        return newMap;
    }

    @Override
    public synchronized String toString() {
        return this.map.toString();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this == o || this.map.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public synchronized V getOrDefault(Object key, V defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    @Override
    public synchronized V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public synchronized V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public synchronized V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public synchronized V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

