/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype;

import liquibase.util.StringUtils;

public class DatabaseDataType {
    private String type;

    public DatabaseDataType(String type) {
        this.type = type;
    }

    public void addAdditionalInformation(String additionalInformation) {
        if (additionalInformation != null) {
            this.type = this.type + " " + additionalInformation;
        }
    }

    public DatabaseDataType(String name, Object ... parameters) {
        this.type = name;
        String[] stringParams = new String[parameters.length];
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                stringParams[i] = parameters[i] == null ? "NULL" : parameters[i].toString();
            }
            this.type = this.type + "(" + StringUtils.join(stringParams, ", ") + ")";
        }
    }

    public boolean isAutoIncrement() {
        return this.type.equalsIgnoreCase("serial") || this.type.equalsIgnoreCase("bigserial") || this.type.equalsIgnoreCase("smallserial");
    }

    public String toSql() {
        return this.toString();
    }

    public String toString() {
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

