<?php
/**
 * QueryService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * QueryService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class QueryService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation getQuerySuggestions
     *
     * Retrieve Flux query suggestions
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\FluxSuggestions|object|\InfluxDB2\Model\Error
     */
    public function getQuerySuggestions($zap_trace_span = null)
    {
        list($response) = $this->getQuerySuggestionsWithHttpInfo($zap_trace_span);
        return $response;
    }

    /**
     * Operation getQuerySuggestionsWithHttpInfo
     *
     * Retrieve Flux query suggestions
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\FluxSuggestions|object|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getQuerySuggestionsWithHttpInfo($zap_trace_span = null)
    {
        $request = $this->getQuerySuggestionsRequest($zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\FluxSuggestions';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getQuerySuggestions'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getQuerySuggestionsRequest($zap_trace_span = null)
    {

        $resourcePath = '/api/v2/query/suggestions';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', 'text/html']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', 'text/html'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getQuerySuggestionsName
     *
     * Retrieve a query suggestion for a branching suggestion
     *
     * @param  string $name A Flux Function name. Only returns functions with this name. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\FluxSuggestion|\InfluxDB2\Model\Error
     */
    public function getQuerySuggestionsName($name, $zap_trace_span = null)
    {
        list($response) = $this->getQuerySuggestionsNameWithHttpInfo($name, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getQuerySuggestionsNameWithHttpInfo
     *
     * Retrieve a query suggestion for a branching suggestion
     *
     * @param  string $name A Flux Function name. Only returns functions with this name. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\FluxSuggestion|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getQuerySuggestionsNameWithHttpInfo($name, $zap_trace_span = null)
    {
        $request = $this->getQuerySuggestionsNameRequest($name, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\FluxSuggestion';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getQuerySuggestionsName'
     *
     * @param  string $name A Flux Function name. Only returns functions with this name. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getQuerySuggestionsNameRequest($name, $zap_trace_span = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getQuerySuggestionsName'
            );
        }

        $resourcePath = '/api/v2/query/suggestions/{name}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postQuery
     *
     * Query data
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept_encoding The content encoding (usually a compression algorithm) that the client can understand. (optional, default to 'identity')
     * @param  string $content_type content_type (optional)
     * @param  string $org The name or ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $org_id The ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query or specification to execute (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function postQuery($zap_trace_span = null, $accept_encoding = 'identity', $content_type = null, $org = null, $org_id = null, $query = null)
    {
        list($response) = $this->postQueryWithHttpInfo($zap_trace_span, $accept_encoding, $content_type, $org, $org_id, $query);
        return $response;
    }

    /**
     * Operation postQueryWithHttpInfo
     *
     * Query data
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept_encoding The content encoding (usually a compression algorithm) that the client can understand. (optional, default to 'identity')
     * @param  string $content_type (optional)
     * @param  string $org The name or ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $org_id The ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query or specification to execute (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postQueryWithHttpInfo($zap_trace_span = null, $accept_encoding = 'identity', $content_type = null, $org = null, $org_id = null, $query = null)
    {
        $request = $this->postQueryRequest($zap_trace_span, $accept_encoding, $content_type, $org, $org_id, $query);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postQuery'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept_encoding The content encoding (usually a compression algorithm) that the client can understand. (optional, default to 'identity')
     * @param  string $content_type (optional)
     * @param  string $org The name or ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $org_id The ID of the organization executing the query.  #### InfluxDB Cloud  - Doesn&#39;t use &#x60;org&#x60; or &#x60;orgID&#x60;. - Queries the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query or specification to execute (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postQueryRequest($zap_trace_span = null, $accept_encoding = 'identity', $content_type = null, $org = null, $org_id = null, $query = null)
    {

        $resourcePath = '/api/v2/query';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($accept_encoding !== null) {
            $headerParams['Accept-Encoding'] = ObjectSerializer::toHeaderValue($accept_encoding);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }


        // body params
        $_tempBody = null;
        if (isset($query)) {
            $_tempBody = $query;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/csv', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/csv', 'application/json'],
                ['application/json', 'application/vnd.flux']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postQueryAnalyze
     *
     * Analyze a Flux query
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type content_type (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query to analyze (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\AnalyzeQueryResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postQueryAnalyze($zap_trace_span = null, $content_type = null, $query = null)
    {
        list($response) = $this->postQueryAnalyzeWithHttpInfo($zap_trace_span, $content_type, $query);
        return $response;
    }

    /**
     * Operation postQueryAnalyzeWithHttpInfo
     *
     * Analyze a Flux query
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query to analyze (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\AnalyzeQueryResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postQueryAnalyzeWithHttpInfo($zap_trace_span = null, $content_type = null, $query = null)
    {
        $request = $this->postQueryAnalyzeRequest($zap_trace_span, $content_type, $query);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\AnalyzeQueryResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postQueryAnalyze'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional)
     * @param  \InfluxDB2\Model\Query $query Flux query to analyze (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postQueryAnalyzeRequest($zap_trace_span = null, $content_type = null, $query = null)
    {

        $resourcePath = '/api/v2/query/analyze';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }


        // body params
        $_tempBody = null;
        if (isset($query)) {
            $_tempBody = $query;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postQueryAst
     *
     * Generate a query Abstract Syntax Tree (AST)
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type content_type (optional)
     * @param  \InfluxDB2\Model\LanguageRequest $language_request The Flux query to analyze. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ASTResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postQueryAst($zap_trace_span = null, $content_type = null, $language_request = null)
    {
        list($response) = $this->postQueryAstWithHttpInfo($zap_trace_span, $content_type, $language_request);
        return $response;
    }

    /**
     * Operation postQueryAstWithHttpInfo
     *
     * Generate a query Abstract Syntax Tree (AST)
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional)
     * @param  \InfluxDB2\Model\LanguageRequest $language_request The Flux query to analyze. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ASTResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postQueryAstWithHttpInfo($zap_trace_span = null, $content_type = null, $language_request = null)
    {
        $request = $this->postQueryAstRequest($zap_trace_span, $content_type, $language_request);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ASTResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postQueryAst'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional)
     * @param  \InfluxDB2\Model\LanguageRequest $language_request The Flux query to analyze. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postQueryAstRequest($zap_trace_span = null, $content_type = null, $language_request = null)
    {

        $resourcePath = '/api/v2/query/ast';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }


        // body params
        $_tempBody = null;
        if (isset($language_request)) {
            $_tempBody = $language_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
