// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

export {
  using ::double_t _LIBCPP_USING_IF_EXISTS;
  using ::float_t _LIBCPP_USING_IF_EXISTS;

  using ::acos _LIBCPP_USING_IF_EXISTS;
  using ::acosf _LIBCPP_USING_IF_EXISTS;
  using ::acosl _LIBCPP_USING_IF_EXISTS;

  using ::asin _LIBCPP_USING_IF_EXISTS;
  using ::asinf _LIBCPP_USING_IF_EXISTS;
  using ::asinl _LIBCPP_USING_IF_EXISTS;

  using ::atan _LIBCPP_USING_IF_EXISTS;
  using ::atanf _LIBCPP_USING_IF_EXISTS;
  using ::atanl _LIBCPP_USING_IF_EXISTS;

  using ::atan2 _LIBCPP_USING_IF_EXISTS;
  using ::atan2f _LIBCPP_USING_IF_EXISTS;
  using ::atan2l _LIBCPP_USING_IF_EXISTS;

  using ::cos _LIBCPP_USING_IF_EXISTS;
  using ::cosf _LIBCPP_USING_IF_EXISTS;
  using ::cosl _LIBCPP_USING_IF_EXISTS;

  using ::sin _LIBCPP_USING_IF_EXISTS;
  using ::sinf _LIBCPP_USING_IF_EXISTS;
  using ::sinl _LIBCPP_USING_IF_EXISTS;

  using ::tan _LIBCPP_USING_IF_EXISTS;
  using ::tanf _LIBCPP_USING_IF_EXISTS;
  using ::tanl _LIBCPP_USING_IF_EXISTS;

  using ::acosh _LIBCPP_USING_IF_EXISTS;
  using ::acoshf _LIBCPP_USING_IF_EXISTS;
  using ::acoshl _LIBCPP_USING_IF_EXISTS;

  using ::asinh _LIBCPP_USING_IF_EXISTS;
  using ::asinhf _LIBCPP_USING_IF_EXISTS;
  using ::asinhl _LIBCPP_USING_IF_EXISTS;

  using ::atanh _LIBCPP_USING_IF_EXISTS;
  using ::atanhf _LIBCPP_USING_IF_EXISTS;
  using ::atanhl _LIBCPP_USING_IF_EXISTS;

  using ::cosh _LIBCPP_USING_IF_EXISTS;
  using ::coshf _LIBCPP_USING_IF_EXISTS;
  using ::coshl _LIBCPP_USING_IF_EXISTS;

  using ::sinh _LIBCPP_USING_IF_EXISTS;
  using ::sinhf _LIBCPP_USING_IF_EXISTS;
  using ::sinhl _LIBCPP_USING_IF_EXISTS;

  using ::tanh _LIBCPP_USING_IF_EXISTS;
  using ::tanhf _LIBCPP_USING_IF_EXISTS;
  using ::tanhl _LIBCPP_USING_IF_EXISTS;

  using ::exp _LIBCPP_USING_IF_EXISTS;
  using ::expf _LIBCPP_USING_IF_EXISTS;
  using ::expl _LIBCPP_USING_IF_EXISTS;

  using ::exp2 _LIBCPP_USING_IF_EXISTS;
  using ::exp2f _LIBCPP_USING_IF_EXISTS;
  using ::exp2l _LIBCPP_USING_IF_EXISTS;

  using ::expm1 _LIBCPP_USING_IF_EXISTS;
  using ::expm1f _LIBCPP_USING_IF_EXISTS;
  using ::expm1l _LIBCPP_USING_IF_EXISTS;

  using ::frexp _LIBCPP_USING_IF_EXISTS;
  using ::frexpf _LIBCPP_USING_IF_EXISTS;
  using ::frexpl _LIBCPP_USING_IF_EXISTS;

  using ::ilogb _LIBCPP_USING_IF_EXISTS;
  using ::ilogbf _LIBCPP_USING_IF_EXISTS;
  using ::ilogbl _LIBCPP_USING_IF_EXISTS;

  using ::ldexp _LIBCPP_USING_IF_EXISTS;
  using ::ldexpf _LIBCPP_USING_IF_EXISTS;
  using ::ldexpl _LIBCPP_USING_IF_EXISTS;

  using ::log _LIBCPP_USING_IF_EXISTS;
  using ::logf _LIBCPP_USING_IF_EXISTS;
  using ::logl _LIBCPP_USING_IF_EXISTS;

  using ::log10 _LIBCPP_USING_IF_EXISTS;
  using ::log10f _LIBCPP_USING_IF_EXISTS;
  using ::log10l _LIBCPP_USING_IF_EXISTS;

  using ::log1p _LIBCPP_USING_IF_EXISTS;
  using ::log1pf _LIBCPP_USING_IF_EXISTS;
  using ::log1pl _LIBCPP_USING_IF_EXISTS;

  using ::log2 _LIBCPP_USING_IF_EXISTS;
  using ::log2f _LIBCPP_USING_IF_EXISTS;
  using ::log2l _LIBCPP_USING_IF_EXISTS;

  using ::logb _LIBCPP_USING_IF_EXISTS;
  using ::logbf _LIBCPP_USING_IF_EXISTS;
  using ::logbl _LIBCPP_USING_IF_EXISTS;

  using ::modf _LIBCPP_USING_IF_EXISTS;
  using ::modff _LIBCPP_USING_IF_EXISTS;
  using ::modfl _LIBCPP_USING_IF_EXISTS;

  using ::scalbn _LIBCPP_USING_IF_EXISTS;
  using ::scalbnf _LIBCPP_USING_IF_EXISTS;
  using ::scalbnl _LIBCPP_USING_IF_EXISTS;

  using ::scalbln _LIBCPP_USING_IF_EXISTS;
  using ::scalblnf _LIBCPP_USING_IF_EXISTS;
  using ::scalblnl _LIBCPP_USING_IF_EXISTS;

  using ::cbrt _LIBCPP_USING_IF_EXISTS;
  using ::cbrtf _LIBCPP_USING_IF_EXISTS;
  using ::cbrtl _LIBCPP_USING_IF_EXISTS;

  // [c.math.abs], absolute values
  using ::abs _LIBCPP_USING_IF_EXISTS;

  using ::fabs _LIBCPP_USING_IF_EXISTS;
  using ::fabsf _LIBCPP_USING_IF_EXISTS;
  using ::fabsl _LIBCPP_USING_IF_EXISTS;

  using ::hypot _LIBCPP_USING_IF_EXISTS;
  using ::hypotf _LIBCPP_USING_IF_EXISTS;
  using ::hypotl _LIBCPP_USING_IF_EXISTS;

  // [c.math.hypot3], three-dimensional hypotenuse

  using ::pow _LIBCPP_USING_IF_EXISTS;
  using ::powf _LIBCPP_USING_IF_EXISTS;
  using ::powl _LIBCPP_USING_IF_EXISTS;

  using ::sqrt _LIBCPP_USING_IF_EXISTS;
  using ::sqrtf _LIBCPP_USING_IF_EXISTS;
  using ::sqrtl _LIBCPP_USING_IF_EXISTS;

  using ::erf _LIBCPP_USING_IF_EXISTS;
  using ::erff _LIBCPP_USING_IF_EXISTS;
  using ::erfl _LIBCPP_USING_IF_EXISTS;

  using ::erfc _LIBCPP_USING_IF_EXISTS;
  using ::erfcf _LIBCPP_USING_IF_EXISTS;
  using ::erfcl _LIBCPP_USING_IF_EXISTS;

  using ::lgamma _LIBCPP_USING_IF_EXISTS;
  using ::lgammaf _LIBCPP_USING_IF_EXISTS;
  using ::lgammal _LIBCPP_USING_IF_EXISTS;

  using ::tgamma _LIBCPP_USING_IF_EXISTS;
  using ::tgammaf _LIBCPP_USING_IF_EXISTS;
  using ::tgammal _LIBCPP_USING_IF_EXISTS;

  using ::ceil _LIBCPP_USING_IF_EXISTS;
  using ::ceilf _LIBCPP_USING_IF_EXISTS;
  using ::ceill _LIBCPP_USING_IF_EXISTS;

  using ::floor _LIBCPP_USING_IF_EXISTS;
  using ::floorf _LIBCPP_USING_IF_EXISTS;
  using ::floorl _LIBCPP_USING_IF_EXISTS;

  using ::nearbyint _LIBCPP_USING_IF_EXISTS;
  using ::nearbyintf _LIBCPP_USING_IF_EXISTS;
  using ::nearbyintl _LIBCPP_USING_IF_EXISTS;

  using ::rint _LIBCPP_USING_IF_EXISTS;
  using ::rintf _LIBCPP_USING_IF_EXISTS;
  using ::rintl _LIBCPP_USING_IF_EXISTS;

  using ::lrint _LIBCPP_USING_IF_EXISTS;
  using ::lrintf _LIBCPP_USING_IF_EXISTS;
  using ::lrintl _LIBCPP_USING_IF_EXISTS;

  using ::llrint _LIBCPP_USING_IF_EXISTS;
  using ::llrintf _LIBCPP_USING_IF_EXISTS;
  using ::llrintl _LIBCPP_USING_IF_EXISTS;

  using ::round _LIBCPP_USING_IF_EXISTS;
  using ::roundf _LIBCPP_USING_IF_EXISTS;
  using ::roundl _LIBCPP_USING_IF_EXISTS;

  using ::lround _LIBCPP_USING_IF_EXISTS;
  using ::lroundf _LIBCPP_USING_IF_EXISTS;
  using ::lroundl _LIBCPP_USING_IF_EXISTS;

  using ::llround _LIBCPP_USING_IF_EXISTS;
  using ::llroundf _LIBCPP_USING_IF_EXISTS;
  using ::llroundl _LIBCPP_USING_IF_EXISTS;

  using ::trunc _LIBCPP_USING_IF_EXISTS;
  using ::truncf _LIBCPP_USING_IF_EXISTS;
  using ::truncl _LIBCPP_USING_IF_EXISTS;

  using ::fmod _LIBCPP_USING_IF_EXISTS;
  using ::fmodf _LIBCPP_USING_IF_EXISTS;
  using ::fmodl _LIBCPP_USING_IF_EXISTS;

  using ::remainder _LIBCPP_USING_IF_EXISTS;
  using ::remainderf _LIBCPP_USING_IF_EXISTS;
  using ::remainderl _LIBCPP_USING_IF_EXISTS;

  using ::remquo _LIBCPP_USING_IF_EXISTS;
  using ::remquof _LIBCPP_USING_IF_EXISTS;
  using ::remquol _LIBCPP_USING_IF_EXISTS;

  using ::copysign _LIBCPP_USING_IF_EXISTS;
  using ::copysignf _LIBCPP_USING_IF_EXISTS;
  using ::copysignl _LIBCPP_USING_IF_EXISTS;

  using ::nan _LIBCPP_USING_IF_EXISTS;
  using ::nanf _LIBCPP_USING_IF_EXISTS;
  using ::nanl _LIBCPP_USING_IF_EXISTS;

  using ::nextafter _LIBCPP_USING_IF_EXISTS;
  using ::nextafterf _LIBCPP_USING_IF_EXISTS;
  using ::nextafterl _LIBCPP_USING_IF_EXISTS;

  using ::nexttoward _LIBCPP_USING_IF_EXISTS;
  using ::nexttowardf _LIBCPP_USING_IF_EXISTS;
  using ::nexttowardl _LIBCPP_USING_IF_EXISTS;

  using ::fdim _LIBCPP_USING_IF_EXISTS;
  using ::fdimf _LIBCPP_USING_IF_EXISTS;
  using ::fdiml _LIBCPP_USING_IF_EXISTS;

  using ::fmax _LIBCPP_USING_IF_EXISTS;
  using ::fmaxf _LIBCPP_USING_IF_EXISTS;
  using ::fmaxl _LIBCPP_USING_IF_EXISTS;

  using ::fmin _LIBCPP_USING_IF_EXISTS;
  using ::fminf _LIBCPP_USING_IF_EXISTS;
  using ::fminl _LIBCPP_USING_IF_EXISTS;

  using ::fma _LIBCPP_USING_IF_EXISTS;
  using ::fmaf _LIBCPP_USING_IF_EXISTS;
  using ::fmal _LIBCPP_USING_IF_EXISTS;

  // [c.math.lerp], linear interpolation
  // [support.c.headers.other]/1
  // ...  placed within the global namespace scope, except for the functions
  // described in [sf.cmath], the std::lerp function overloads ([c.math.lerp])
  // ...

  // [c.math.fpclass], classification / comparison functions
  using ::fpclassify _LIBCPP_USING_IF_EXISTS;
  using ::isfinite _LIBCPP_USING_IF_EXISTS;
  using ::isgreater _LIBCPP_USING_IF_EXISTS;
  using ::isgreaterequal _LIBCPP_USING_IF_EXISTS;
  using ::isinf _LIBCPP_USING_IF_EXISTS;
  using ::isless _LIBCPP_USING_IF_EXISTS;
  using ::islessequal _LIBCPP_USING_IF_EXISTS;
  using ::islessgreater _LIBCPP_USING_IF_EXISTS;
  using ::isnan _LIBCPP_USING_IF_EXISTS;
  using ::isnormal _LIBCPP_USING_IF_EXISTS;
  using ::isunordered _LIBCPP_USING_IF_EXISTS;
  using ::signbit _LIBCPP_USING_IF_EXISTS;

  // [sf.cmath], mathematical special functions
} // export
