/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.triangulate.polygon.PolygonEarClipper;
import org.locationtech.jts.triangulate.polygon.PolygonHoleJoiner;
import org.locationtech.jts.triangulate.polygon.TriDelaunayImprover;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.triangulate.tri.TriangulationBuilder;

public class ConstrainedDelaunayTriangulator {
    private final GeometryFactory geomFact;
    private final Geometry inputGeom;
    private List<Tri> triList;

    public static Geometry triangulate(Geometry geom) {
        ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(geom);
        return cdt.getResult();
    }

    public ConstrainedDelaunayTriangulator(Geometry inputGeom) {
        this.geomFact = inputGeom.getFactory();
        this.inputGeom = inputGeom;
    }

    public Geometry getResult() {
        this.compute();
        return Tri.toGeometry(this.triList, this.geomFact);
    }

    public List<Tri> getTriangles() {
        this.compute();
        return this.triList;
    }

    private void compute() {
        if (this.triList != null) {
            return;
        }
        List polys = PolygonExtracter.getPolygons(this.inputGeom);
        this.triList = new ArrayList<Tri>();
        for (Polygon poly : polys) {
            List<Tri> polyTriList = this.triangulatePolygon(poly);
            this.triList.addAll(polyTriList);
        }
    }

    List<Tri> triangulatePolygon(Polygon poly) {
        Polygon polyNorm = (Polygon)poly.norm();
        Coordinate[] polyShell = PolygonHoleJoiner.join(polyNorm);
        List<Tri> triList = PolygonEarClipper.triangulate(polyShell);
        TriangulationBuilder.build(triList);
        TriDelaunayImprover.improve(triList);
        return triList;
    }
}

