/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.operator;

import java.util.Set;

public enum OperatorType {
    PIPE("|", false, true),
    PIPE_AND_ERROR("|&"),
    REDIRECT_OUT(">", true, true),
    REDIRECT_OUT_ERROR("2>", true, true),
    REDIRECT_IN("<", true, true),
    END(";"),
    APPEND_OUT(">>", true, true),
    APPEND_OUT_ERROR("2>>", true, true),
    REDIRECT_OUT_ALL("2>&1", true, true),
    AMP("&", true, true),
    AND("&&"),
    OR("||"),
    NONE("");

    private final String value;
    private final boolean hasArgument;
    private final boolean isConfiguration;

    private OperatorType(String c, boolean hasArgument, boolean isConfiguration) {
        this.value = c;
        this.hasArgument = hasArgument;
        this.isConfiguration = isConfiguration;
    }

    private OperatorType(String c) {
        this.value = c;
        this.hasArgument = false;
        this.isConfiguration = false;
    }

    public String value() {
        return this.value;
    }

    public boolean hasArgument() {
        return this.hasArgument;
    }

    public boolean isConfiguration() {
        return this.isConfiguration;
    }

    public boolean matches(String text, int index) {
        if (text.length() >= index + this.value.length()) {
            for (int i = 0; i < this.value.length(); ++i) {
                if (text.charAt(index + i) == this.value.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAppendOrRedirectInOrOut(OperatorType type) {
        return type == APPEND_OUT || type == REDIRECT_OUT || type == REDIRECT_IN || type == REDIRECT_OUT_ALL || type == REDIRECT_OUT_ERROR || type == APPEND_OUT_ERROR;
    }

    public static OperatorType matches(Set<OperatorType> operators, String text, int index) {
        OperatorType found = NONE;
        for (OperatorType operator : operators) {
            if (!operator.matches(text, index) || found.value().length() >= operator.value().length()) continue;
            found = operator;
        }
        return found;
    }
}

