/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.factory;

import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfiguration;
import org.keycloak.jgroups.certificates.CertificateReloadManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;

@DefaultFactoryFor(classes={CertificateReloadManager.class})
public class CertificateReloadManagerFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        KeycloakConfiguration kcConfig = (KeycloakConfiguration)this.globalConfiguration.module(KeycloakConfiguration.class);
        if (kcConfig == null) {
            return null;
        }
        KeycloakSessionFactory sessionFactory = kcConfig.keycloakSessionFactory();
        if (this.supportsReloadAndRotation(sessionFactory)) {
            return new CertificateReloadManager(sessionFactory);
        }
        return null;
    }

    private boolean supportsReloadAndRotation(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            JGroupsCertificateProvider provider = (JGroupsCertificateProvider)session.getProvider(JGroupsCertificateProvider.class);
            boolean bl = provider != null && provider.isEnabled() && provider.supportRotateAndReload();
            return bl;
        }
    }
}

