/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface ModelRecord {
    public String getId();

    public String getResourceType();

    public record UserModelRecord(UserModel user) implements ModelRecord
    {
        @Override
        public String getResourceType() {
            return "Users";
        }

        @Override
        public String getId() {
            return this.user == null ? null : this.user.getId();
        }
    }

    public record RoleModelRecord(RoleModel role) implements ModelRecord
    {
        @Override
        public String getResourceType() {
            return "Roles";
        }

        @Override
        public String getId() {
            return this.role == null ? null : this.role.getId();
        }
    }

    public record GroupModelRecord(GroupModel group) implements ModelRecord
    {
        @Override
        public String getResourceType() {
            return "Groups";
        }

        @Override
        public String getId() {
            return this.group == null ? null : this.group.getId();
        }
    }

    public record ClientModelRecord(ClientModel client) implements ModelRecord
    {
        @Override
        public String getResourceType() {
            return "Clients";
        }

        @Override
        public String getId() {
            return this.client == null ? null : this.client.getId();
        }
    }
}

