/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.par.endpoints;

import jakarta.ws.rs.Path;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.ext.OIDCExtProvider;
import org.keycloak.protocol.oidc.ext.OIDCExtProviderFactory;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class ParRootEndpoint
implements OIDCExtProvider,
OIDCExtProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "par";
    private final KeycloakSession session;
    private EventBuilder event;

    public ParRootEndpoint() {
        this(null);
    }

    public ParRootEndpoint(KeycloakSession session) {
        this.session = session;
    }

    @Path(value="/request")
    public ParEndpoint request() {
        return new ParEndpoint(this.session, this.event);
    }

    public OIDCExtProvider create(KeycloakSession session) {
        return new ParRootEndpoint(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PAR);
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public void close() {
    }
}

