/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;

public class ClientEdDSASignatureVerifierContext
extends AsymmetricSignatureVerifierContext {
    public ClientEdDSASignatureVerifierContext(KeycloakSession session, ClientModel client, JWSInput input) throws VerificationException {
        super(ClientEdDSASignatureVerifierContext.getKey(session, client, input));
    }

    private static KeyWrapper getKey(KeycloakSession session, ClientModel client, JWSInput input) throws VerificationException {
        KeyWrapper key = PublicKeyStorageManager.getClientPublicKeyWrapper(session, client, input);
        if (key == null) {
            throw new VerificationException("Key not found");
        }
        if (!"OKP".equals(key.getType())) {
            throw new VerificationException("Key Type is not OKP: " + key.getType());
        }
        if (key.getCurve() == null) {
            throw new VerificationException("EdDSA key should have curve defined");
        }
        if (key.getAlgorithm() == null) {
            key.setAlgorithm(input.getHeader().getRawAlgorithm());
        }
        return key;
    }
}

