/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class ConditionalSubFlowExecutedAuthenticator
implements ConditionalAuthenticator {
    protected static final ConditionalSubFlowExecutedAuthenticator SINGLETON = new ConditionalSubFlowExecutedAuthenticator();
    private static final Logger logger = Logger.getLogger(ConditionalSubFlowExecutedAuthenticator.class);

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        boolean executed;
        AuthenticatorConfigModel configModel = context.getAuthenticatorConfig();
        if (configModel == null || configModel.getConfig() == null) {
            logger.warnf("No configuration defined for the conditional flow executed. Nothing executed.", new Object[0]);
            return false;
        }
        String flowAlias = (String)configModel.getConfig().get("flow_to_check");
        boolean bl = executed = !"not-executed".equals(configModel.getConfig().get("check_result"));
        if (flowAlias == null) {
            logger.warnf("No flow configured in the option '%s'. Nothing executed.", (Object)"flow_to_check");
            return !executed;
        }
        RealmModel realm = context.getRealm();
        AuthenticationFlowModel flow = realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.warnf("No flow '%s' defined in the realm. Nothing executed.", (Object)flowAlias);
            return !executed;
        }
        AuthenticationExecutionModel exec = this.locateExecutionFlowToCheck(realm, context.getTopLevelFlow().getId(), flow.getId());
        if (exec == null) {
            logger.warnf("Cannot locate execution for flow '%s' in the top level flow '%s'. Nothing executed.", (Object)flowAlias, (Object)context.getTopLevelFlow().getAlias());
            return !executed;
        }
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)context.getAuthenticationSession().getExecutionStatus().get(exec.getId());
        logger.tracef("The authentication status for the flow '%s' is %s", (Object)flowAlias, (Object)status);
        return executed ? CommonClientSessionModel.ExecutionStatus.SUCCESS.equals((Object)status) : !CommonClientSessionModel.ExecutionStatus.SUCCESS.equals((Object)status);
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    private Stream<AuthenticationExecutionModel> flattened(RealmModel realm, AuthenticationExecutionModel flowExec) {
        return Stream.concat(Stream.of(flowExec), realm.getAuthenticationExecutionsStream(flowExec.getFlowId()).filter(AuthenticationExecutionModel::isAuthenticatorFlow).flatMap(exec -> this.flattened(realm, (AuthenticationExecutionModel)exec)));
    }

    private AuthenticationExecutionModel locateExecutionFlowToCheck(RealmModel realm, String topFlowId, String flowId) {
        return realm.getAuthenticationExecutionsStream(topFlowId).filter(AuthenticationExecutionModel::isAuthenticatorFlow).flatMap(exec -> this.flattened(realm, (AuthenticationExecutionModel)exec)).filter(exec -> flowId.equals(exec.getFlowId())).findAny().orElse(null);
    }
}

