/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.keycloak.authorization.jpa.entities.ResourceAttributeEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_RESOURCE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID", "OWNER"})})
@NamedQueries(value={@NamedQuery(name="findResourceIdByOwner", query="select r from ResourceEntity r  where r.resourceServer = :serverId and r.owner = :owner"), @NamedQuery(name="findResourceIdByOwnerOrdered", query="select r from ResourceEntity r where r.resourceServer = :serverId and r.owner = :owner order by r.id"), @NamedQuery(name="findAnyResourceIdByOwner", query="select r from ResourceEntity r where r.owner = :owner"), @NamedQuery(name="findAnyResourceIdByOwnerOrdered", query="select r.id from ResourceEntity r where r.owner = :owner order by r.id"), @NamedQuery(name="findResourceIdByUri", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId  and :uri in elements(r.uris)"), @NamedQuery(name="findResourceIdByName", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.name = :name"), @NamedQuery(name="findResourceIdByType", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.type = :type"), @NamedQuery(name="findResourceIdByTypeNoOwner", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.type = :type"), @NamedQuery(name="findResourceIdByTypeInstance", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId and r.type = :type and r.owner <> :serverId"), @NamedQuery(name="findResourceIdByServerId", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId "), @NamedQuery(name="findResourceIdByScope", query="select r from ResourceEntity r inner join r.scopes s where r.resourceServer = :serverId and (s.resourceServer.id = :serverId and s.id in (:scopeIds))"), @NamedQuery(name="deleteResourceByResourceServer", query="delete from ResourceEntity r where r.resourceServer = :serverId")})
public class ResourceEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @ElementCollection(fetch=FetchType.LAZY)
    @Column(name="VALUE")
    @CollectionTable(name="RESOURCE_URIS", joinColumns={@JoinColumn(name="RESOURCE_ID")})
    private Set<String> uris;
    @Column(name="TYPE")
    private String type;
    @Column(name="ICON_URI")
    private String iconUri;
    @Column(name="OWNER")
    private String owner;
    @Column(name="OWNER_MANAGED_ACCESS")
    private boolean ownerManagedAccess;
    @Column(name="RESOURCE_SERVER_ID")
    private String resourceServer;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_SCOPE", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    private List<ScopeEntity> scopes;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=false, mappedBy="resource", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    private Collection<ResourceAttributeEntity> attributes = new LinkedList<ResourceAttributeEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Set<String> getUris() {
        if (this.uris == null) {
            this.uris = new HashSet<String>();
        }
        return this.uris;
    }

    public void setUris(Set<String> uris) {
        this.uris = uris;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ScopeEntity> getScopes() {
        if (this.scopes == null) {
            this.scopes = new LinkedList<ScopeEntity>();
        }
        return this.scopes;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public String getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(String resourceServer) {
        this.resourceServer = resourceServer;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public boolean isOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public Collection<ResourceAttributeEntity> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList<ResourceAttributeEntity>();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ResourceAttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntity that = (ResourceEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

