/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.util.JsonSerialization;

public class JWKSUtils {
    private static final Logger logger = Logger.getLogger(JWKSUtils.class.getName());
    private static final String JWK_THUMBPRINT_DEFAULT_HASH_ALGORITHM = "SHA-256";
    private static final Map<String, String[]> JWK_THUMBPRINT_REQUIRED_MEMBERS = new HashMap<String, String[]>();

    @Deprecated
    public static Map<String, PublicKey> getKeysForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        return JWKSUtils.getKeyWrappersForUse(keySet, requestedUse).getKeys().stream().collect(Collectors.toMap(KeyWrapper::getKid, keyWrapper -> (PublicKey)keyWrapper.getPublicKey()));
    }

    public static PublicKeysWrapper getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        return JWKSUtils.getKeyWrappersForUse(keySet, requestedUse, false);
    }

    public static PublicKeysWrapper getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse, boolean useRequestedUseWhenNull) {
        ArrayList<KeyWrapper> result = new ArrayList<KeyWrapper>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (jwk.getPublicKeyUse() == null && !useRequestedUseWhenNull) {
                logger.debugf("Ignoring JWK key '%s'. Missing required field 'use'.", (Object)jwk.getKeyId());
                continue;
            }
            if (!requestedUse.asString().equals(jwk.getPublicKeyUse()) && (jwk.getPublicKeyUse() != null || !useRequestedUseWhenNull) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            try {
                KeyWrapper keyWrapper = JWKSUtils.wrap(jwk, parser);
                keyWrapper.setUse(JWKSUtils.getKeyUse(requestedUse.asString()));
                result.add(keyWrapper);
            }
            catch (RuntimeException e) {
                logger.debugf((Throwable)e, "Ignoring JWK key '%s'. Failed to load key.", (Object)jwk.getKeyId());
            }
        }
        return new PublicKeysWrapper(result);
    }

    private static KeyUse getKeyUse(String keyUse) {
        if (keyUse == null) {
            return null;
        }
        switch (keyUse) {
            case "sig": {
                return KeyUse.SIG;
            }
            case "enc": {
                return KeyUse.ENC;
            }
        }
        return null;
    }

    public static JWK getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (jwk.getPublicKeyUse() == null) {
                logger.debugf("Ignoring JWK key '%s'. Missing required field 'use'.", (Object)jwk.getKeyId());
                continue;
            }
            if (!requestedUse.asString().equals(parser.getJwk().getPublicKeyUse()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            return jwk;
        }
        return null;
    }

    public static KeyWrapper getKeyWrapper(JWK jwk) {
        JWKParser parser = JWKParser.create(jwk);
        if (parser.isKeyTypeSupported(jwk.getKeyType())) {
            return JWKSUtils.wrap(jwk, parser);
        }
        return null;
    }

    private static KeyWrapper wrap(JWK jwk, JWKParser parser) {
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setKid(jwk.getKeyId());
        if (jwk.getAlgorithm() != null) {
            keyWrapper.setAlgorithm(jwk.getAlgorithm());
        }
        if (jwk.getOtherClaims().get("crv") != null) {
            keyWrapper.setCurve((String)jwk.getOtherClaims().get("crv"));
        }
        keyWrapper.setType(jwk.getKeyType());
        keyWrapper.setUse(JWKSUtils.getKeyUse(jwk.getPublicKeyUse()));
        keyWrapper.setPublicKey(parser.toPublicKey());
        return keyWrapper;
    }

    public static String computeThumbprint(JWK key) {
        return JWKSUtils.computeThumbprint(key, JWK_THUMBPRINT_DEFAULT_HASH_ALGORITHM);
    }

    public static String computeThumbprint(JWK key, String hashAlg) {
        String kty = key.getKeyType();
        String[] requiredMembers = JWK_THUMBPRINT_REQUIRED_MEMBERS.get(kty);
        if (requiredMembers == null) {
            throw new UnsupportedOperationException("Unsupported key type: " + kty);
        }
        TreeMap<String, String> members = new TreeMap<String, String>();
        members.put("kty", kty);
        try {
            JsonNode node = JsonSerialization.writeValueAsNode(key);
            for (String member : requiredMembers) {
                members.put(member, node.get(member).asText());
            }
            byte[] bytes = JsonSerialization.writeValueAsBytes(members);
            byte[] hash = HashUtils.hash(hashAlg, bytes);
            return Base64Url.encode(hash);
        }
        catch (IOException ex) {
            logger.debugf((Throwable)ex, "Failed to compute JWK thumbprint for key '%s'.", (Object)key.getKeyId());
            return null;
        }
    }

    static {
        JWK_THUMBPRINT_REQUIRED_MEMBERS.put("RSA", new String[]{"n", "e"});
        JWK_THUMBPRINT_REQUIRED_MEMBERS.put("EC", new String[]{"crv", "x", "y"});
    }
}

