/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java2d.Surface;

public class Curves
extends Surface {
    private static Color[] colors = new Color[]{Color.BLUE, Color.GREEN, Color.RED};

    public Curves() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        g2.setColor(Color.BLACK);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout("QuadCurve2D", g2.getFont(), frc);
        float xx = (float)((double)w * 0.5 - tl.getBounds().getWidth() / 2.0);
        tl.draw(g2, xx, tl.getAscent());
        tl = new TextLayout("CubicCurve2D", g2.getFont(), frc);
        xx = (float)((double)w * 0.5 - tl.getBounds().getWidth() / 2.0);
        tl.draw(g2, xx, (float)h * 0.5f);
        g2.setStroke(new BasicStroke(5.0f));
        float yy = 20.0f;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                Shape shape = null;
                shape = i == 0 ? new QuadCurve2D.Float((float)w * 0.1f, yy, (float)w * 0.5f, 50.0f, (float)w * 0.9f, yy) : new CubicCurve2D.Float((float)w * 0.1f, yy, (float)w * 0.4f, yy - 15.0f, (float)w * 0.6f, yy + 15.0f, (float)w * 0.9f, yy);
                g2.setColor(colors[j]);
                if (j != 2) {
                    g2.draw(shape);
                }
                if (j == 1) {
                    g2.setColor(Color.LIGHT_GRAY);
                    PathIterator f = shape.getPathIterator(null);
                    while (!f.isDone()) {
                        float[] pts = new float[6];
                        switch (f.currentSegment(pts)) {
                            case 0: 
                            case 1: {
                                g2.fill(new Rectangle2D.Float(pts[0], pts[1], 5.0f, 5.0f));
                                break;
                            }
                            case 2: 
                            case 3: {
                                g2.fill(new Rectangle2D.Float(pts[0], pts[1], 5.0f, 5.0f));
                                if (pts[2] != 0.0f) {
                                    g2.fill(new Rectangle2D.Float(pts[2], pts[3], 5.0f, 5.0f));
                                }
                                if (pts[4] == 0.0f) break;
                                g2.fill(new Rectangle2D.Float(pts[4], pts[5], 5.0f, 5.0f));
                            }
                        }
                        f.next();
                    }
                } else if (j == 2) {
                    PathIterator p = shape.getPathIterator(null);
                    FlatteningPathIterator f = new FlatteningPathIterator(p, 0.1);
                    while (!f.isDone()) {
                        float[] pts = new float[6];
                        switch (f.currentSegment(pts)) {
                            case 0: 
                            case 1: {
                                g2.fill(new Ellipse2D.Float(pts[0], pts[1], 3.0f, 3.0f));
                            }
                        }
                        f.next();
                    }
                }
                yy += (float)(h / 6);
            }
            yy = h / 2 + 15;
        }
    }

    public static void main(String[] argv) {
        Curves.createDemoFrame(new Curves());
    }
}

