/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import sun.security.action.GetPropertyAction;
import sun.security.smartcardio.CardImpl;
import sun.security.smartcardio.PCSC;
import sun.security.smartcardio.PCSCException;

final class ChannelImpl
extends CardChannel {
    private final CardImpl card;
    private final int channel;
    private volatile boolean isClosed;
    private static final boolean t0GetResponse = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t0GetResponse", true);
    private static final boolean t1GetResponse = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t1GetResponse", true);
    private static final boolean t1StripLe = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t1StripLe", false);
    private static final int RESPONSE_ITERATIONS = 256;
    private static final byte[] B0 = new byte[0];

    ChannelImpl(CardImpl cardImpl, int n) {
        this.card = cardImpl;
        this.channel = n;
    }

    void checkClosed() {
        this.card.checkState();
        if (this.isClosed) {
            throw new IllegalStateException("Logical channel has been closed");
        }
    }

    @Override
    public Card getCard() {
        return this.card;
    }

    @Override
    public int getChannelNumber() {
        this.checkClosed();
        return this.channel;
    }

    private static void checkManageChannel(byte[] byArray) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("Command APDU must be at least 4 bytes long");
        }
        if (byArray[0] >= 0 && byArray[1] == 112) {
            throw new IllegalArgumentException("Manage channel command not allowed, use openLogicalChannel()");
        }
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
        this.checkClosed();
        this.card.checkExclusive();
        byte[] byArray = commandAPDU.getBytes();
        byte[] byArray2 = this.doTransmit(byArray);
        return new ResponseAPDU(byArray2);
    }

    @Override
    public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
        this.checkClosed();
        this.card.checkExclusive();
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException();
        }
        if (byteBuffer2.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("command and response must not be the same object");
        }
        if (byteBuffer2.remaining() < 258) {
            throw new IllegalArgumentException("Insufficient space in response buffer");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        byte[] byArray2 = this.doTransmit(byArray);
        byteBuffer2.put(byArray2);
        return byArray2.length;
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(string + " must be either 'true' or 'false'");
    }

    private byte[] concat(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        if (n2 == 0 && n == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n2 + n];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray2, 0, byArray3, n2, n);
        return byArray3;
    }

    private byte[] doTransmit(byte[] byArray) throws CardException {
        try {
            int n;
            byte[] byArray2;
            int n2;
            boolean bl;
            ChannelImpl.checkManageChannel(byArray);
            this.setChannel(byArray);
            int n3 = byArray.length;
            boolean bl2 = this.card.protocol == 1;
            boolean bl3 = bl = this.card.protocol == 2;
            if (bl2 && n3 >= 7 && byArray[4] == 0) {
                throw new CardException("Extended length forms not supported for T=0");
            }
            if ((bl2 || bl && t1StripLe) && n3 >= 7) {
                n2 = byArray[4] & 0xFF;
                if (n2 != 0) {
                    if (n3 == n2 + 6) {
                        --n3;
                    }
                } else {
                    n2 = (byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF;
                    if (n3 == n2 + 9) {
                        n3 -= 2;
                    }
                }
            }
            n2 = bl2 && t0GetResponse || bl && t1GetResponse ? 1 : 0;
            int n4 = 0;
            byte[] byArray3 = B0;
            while (true) {
                if (++n4 > 256) {
                    throw new CardException("Number of response iterations exceeded maximum 256");
                }
                byArray2 = PCSC.SCardTransmit(this.card.cardId, this.card.protocol, byArray, 0, n3);
                n = byArray2.length;
                if (n2 == 0 || n < 2) break;
                if (n == 2 && byArray2[0] == 108) {
                    byArray[n3 - 1] = byArray2[1];
                    continue;
                }
                if (byArray2[n - 2] != 97) break;
                if (n > 2) {
                    byArray3 = this.concat(byArray3, byArray2, n - 2);
                }
                byArray[1] = -64;
                byArray[2] = 0;
                byArray[3] = 0;
                byArray[4] = byArray2[n - 1];
                n3 = 5;
            }
            byArray3 = this.concat(byArray3, byArray2, n);
            return byArray3;
        }
        catch (PCSCException pCSCException) {
            this.card.handleError(pCSCException);
            throw new CardException(pCSCException);
        }
    }

    private static int getSW(byte[] byArray) throws CardException {
        if (byArray.length < 2) {
            throw new CardException("Invalid response length: " + byArray.length);
        }
        int n = byArray[byArray.length - 2] & 0xFF;
        int n2 = byArray[byArray.length - 1] & 0xFF;
        return n << 8 | n2;
    }

    private static boolean isOK(byte[] byArray) throws CardException {
        return byArray.length == 2 && ChannelImpl.getSW(byArray) == 36864;
    }

    private void setChannel(byte[] byArray) {
        byte by = byArray[0];
        if (by < 0) {
            return;
        }
        if ((by & 0xE0) == 32) {
            return;
        }
        if (this.channel <= 3) {
            byArray[0] = (byte)(byArray[0] & 0xBC);
            byArray[0] = (byte)(byArray[0] | this.channel);
        } else if (this.channel <= 19) {
            byArray[0] = (byte)(byArray[0] & 0xB0);
            byArray[0] = (byte)(byArray[0] | 0x40);
            byArray[0] = (byte)(byArray[0] | this.channel - 4);
        } else {
            throw new RuntimeException("Unsupported channel number: " + this.channel);
        }
    }

    @Override
    public void close() throws CardException {
        if (this.getChannelNumber() == 0) {
            throw new IllegalStateException("Cannot close basic logical channel");
        }
        if (this.isClosed) {
            return;
        }
        this.card.checkExclusive();
        try {
            byte[] byArray = new byte[]{0, 112, -128, 0};
            byArray[3] = (byte)this.getChannelNumber();
            this.setChannel(byArray);
            byte[] byArray2 = PCSC.SCardTransmit(this.card.cardId, this.card.protocol, byArray, 0, byArray.length);
            if (!ChannelImpl.isOK(byArray2)) {
                throw new CardException("close() failed: " + PCSC.toString(byArray2));
            }
        }
        catch (PCSCException pCSCException) {
            this.card.handleError(pCSCException);
            throw new CardException("Could not close channel", pCSCException);
        }
        finally {
            this.isClosed = true;
        }
    }

    public String toString() {
        return "PC/SC channel " + this.channel;
    }
}

