/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.log.LogHandler;
import sun.rmi.log.LogInputStream;
import sun.rmi.log.LogOutputStream;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class ReliableLog {
    public static final int PreferredMajorVersion = 0;
    public static final int PreferredMinorVersion = 2;
    private boolean Debug = false;
    private static String snapshotPrefix = "Snapshot.";
    private static String logfilePrefix = "Logfile.";
    private static String versionFile = "Version_Number";
    private static String newVersionFile = "New_Version_Number";
    private static int intBytes = 4;
    private static long diskPageSize = 512L;
    private File dir;
    private int version = 0;
    private String logName = null;
    private LogFile log = null;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private int logEntries = 0;
    private long lastSnapshot = 0L;
    private long lastLog = 0L;
    private LogHandler handler;
    private final byte[] intBuf = new byte[4];
    private int majorFormatVersion = 0;
    private int minorFormatVersion = 0;
    private static final Constructor<? extends LogFile> logClassConstructor = ReliableLog.getLogClassConstructor();

    public ReliableLog(String string, LogHandler logHandler, boolean bl) throws IOException {
        this.Debug = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.log.debug"));
        this.dir = new File(string);
        if (!(this.dir.exists() && this.dir.isDirectory() || this.dir.mkdir())) {
            throw new IOException("could not create directory for log: " + string);
        }
        this.handler = logHandler;
        this.lastSnapshot = 0L;
        this.lastLog = 0L;
        this.getVersion();
        if (this.version == 0) {
            try {
                this.snapshot(logHandler.initialSnapshot());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("initial snapshot failed with exception: " + exception);
            }
        }
    }

    public ReliableLog(String string, LogHandler logHandler) throws IOException {
        this(string, logHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object recover() throws IOException {
        Object object;
        if (this.Debug) {
            System.err.println("log.debug: recover()");
        }
        if (this.version == 0) {
            return null;
        }
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        if (this.Debug) {
            System.err.println("log.debug: recovering from " + string);
        }
        try {
            try {
                object = this.handler.recover(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                if (this.Debug) {
                    System.err.println("log.debug: recovery failed: " + exception);
                }
                throw new IOException("log recover failed with exception: " + exception);
            }
            this.snapshotBytes = file.length();
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return this.recoverUpdates(object);
    }

    public synchronized void update(Object object) throws IOException {
        this.update(object, true);
    }

    public synchronized void update(Object object, boolean bl) throws IOException {
        if (this.log == null) {
            throw new IOException("log is inaccessible, it may have been corrupted or closed");
        }
        long l = this.log.getFilePointer();
        boolean bl2 = this.log.checkSpansBoundary(l);
        this.writeInt(this.log, bl2 ? Integer.MIN_VALUE : 0);
        try {
            this.handler.writeUpdate(new LogOutputStream(this.log), object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("write update failed").initCause(exception);
        }
        this.log.sync();
        long l2 = this.log.getFilePointer();
        int n = (int)(l2 - l - (long)intBytes);
        this.log.seek(l);
        if (bl2) {
            this.writeInt(this.log, n | Integer.MIN_VALUE);
            this.log.sync();
            this.log.seek(l);
            this.log.writeByte(n >> 24);
            this.log.sync();
        } else {
            this.writeInt(this.log, n);
            this.log.sync();
        }
        this.log.seek(l2);
        this.logBytes = l2;
        this.lastLog = System.currentTimeMillis();
        ++this.logEntries;
    }

    private static Constructor<? extends LogFile> getLogClassConstructor() {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.rmi.log.class"));
        if (string != null) {
            try {
                ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
                Class<LogFile> clazz = classLoader.loadClass(string).asSubclass(LogFile.class);
                return clazz.getConstructor(String.class, String.class);
            }
            catch (Exception exception) {
                System.err.println("Exception occurred:");
                exception.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void snapshot(Object object) throws IOException {
        int n = this.version;
        this.incrVersion();
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                this.handler.snapshot(fileOutputStream, object);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("snapshot failed", exception);
            }
            this.lastSnapshot = System.currentTimeMillis();
        }
        finally {
            fileOutputStream.close();
            this.snapshotBytes = file.length();
        }
        this.openLogFile(true);
        this.writeVersionFile(true);
        this.commitToNewVersion();
        this.deleteSnapshot(n);
        this.deleteLogFile(n);
    }

    public synchronized void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            this.log = null;
        }
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public long logSize() {
        return this.logBytes;
    }

    private void writeInt(DataOutput dataOutput, int n) throws IOException {
        this.intBuf[0] = (byte)(n >> 24);
        this.intBuf[1] = (byte)(n >> 16);
        this.intBuf[2] = (byte)(n >> 8);
        this.intBuf[3] = (byte)n;
        dataOutput.write(this.intBuf);
    }

    private String fName(String string) {
        return this.dir.getPath() + File.separator + string;
    }

    private String versionName(String string) {
        return this.versionName(string, 0);
    }

    private String versionName(String string, int n) {
        n = n == 0 ? this.version : n;
        return this.fName(string) + String.valueOf(n);
    }

    private void incrVersion() {
        do {
            ++this.version;
        } while (this.version == 0);
    }

    private void deleteFile(String string) throws IOException {
        File file = new File(string);
        if (!file.delete()) {
            throw new IOException("couldn't remove file: " + string);
        }
    }

    private void deleteNewVersionFile() throws IOException {
        this.deleteFile(this.fName(newVersionFile));
    }

    private void deleteSnapshot(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(snapshotPrefix, n));
    }

    private void deleteLogFile(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(logfilePrefix, n));
    }

    private void openLogFile(boolean bl) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        try {
            this.log = logClassConstructor == null ? new LogFile(this.logName, "rw") : logClassConstructor.newInstance(this.logName, "rw");
        }
        catch (Exception exception) {
            throw (IOException)new IOException("unable to construct LogFile instance").initCause(exception);
        }
        if (bl) {
            this.initializeLogFile();
        }
    }

    private void initializeLogFile() throws IOException {
        this.log.setLength(0L);
        this.majorFormatVersion = 0;
        this.writeInt(this.log, 0);
        this.minorFormatVersion = 2;
        this.writeInt(this.log, 2);
        this.logBytes = intBytes * 2;
        this.logEntries = 0;
    }

    private void writeVersionFile(boolean bl) throws IOException {
        String string = bl ? newVersionFile : versionFile;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.fName(string));
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            this.writeInt(dataOutputStream, this.version);
        }
    }

    private void createFirstVersion() throws IOException {
        this.version = 0;
        this.writeVersionFile(false);
    }

    private void commitToNewVersion() throws IOException {
        this.writeVersionFile(false);
        this.deleteNewVersionFile();
    }

    private int readVersion(String string) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));){
            int n = dataInputStream.readInt();
            return n;
        }
    }

    private void getVersion() throws IOException {
        try {
            this.version = this.readVersion(this.fName(newVersionFile));
            this.commitToNewVersion();
        }
        catch (IOException iOException) {
            try {
                this.deleteNewVersionFile();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                this.version = this.readVersion(this.fName(versionFile));
            }
            catch (IOException iOException3) {
                this.createFirstVersion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recoverUpdates(Object object) throws IOException {
        this.logBytes = 0L;
        this.logEntries = 0;
        if (this.version == 0) {
            return object;
        }
        String string = this.versionName(logfilePrefix);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        if (this.Debug) {
            System.err.println("log.debug: reading updates from " + string);
        }
        try {
            this.majorFormatVersion = dataInputStream.readInt();
            this.logBytes += (long)intBytes;
            this.minorFormatVersion = dataInputStream.readInt();
            this.logBytes += (long)intBytes;
        }
        catch (EOFException eOFException) {
            this.openLogFile(true);
            bufferedInputStream = null;
        }
        if (this.majorFormatVersion != 0) {
            if (this.Debug) {
                System.err.println("log.debug: major version mismatch: " + this.majorFormatVersion + "." + this.minorFormatVersion);
            }
            throw new IOException("Log file " + this.logName + " has a version " + this.majorFormatVersion + "." + this.minorFormatVersion + " format, and this implementation  understands only version " + 0 + "." + 2);
        }
        try {
            while (bufferedInputStream != null) {
                int n = 0;
                try {
                    n = dataInputStream.readInt();
                }
                catch (EOFException eOFException) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was sync'd cleanly");
                    }
                    break;
                }
                if (n <= 0) {
                    if (this.Debug) {
                        System.err.println("log.debug: last update incomplete, updateLen = 0x" + Integer.toHexString(n));
                    }
                    break;
                }
                if (((InputStream)bufferedInputStream).available() < n) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was truncated");
                    }
                    break;
                }
                if (this.Debug) {
                    System.err.println("log.debug: rdUpdate size " + n);
                }
                try {
                    object = this.handler.readUpdate(new LogInputStream(bufferedInputStream, n), object);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException("read update failed with exception: " + exception);
                }
                this.logBytes += (long)(intBytes + n);
                ++this.logEntries;
            }
        }
        finally {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        if (this.Debug) {
            System.err.println("log.debug: recovered updates: " + this.logEntries);
        }
        this.openLogFile(false);
        if (this.log == null) {
            throw new IOException("rmid's log is inaccessible, it may have been corrupted or closed");
        }
        this.log.seek(this.logBytes);
        this.log.setLength(this.logBytes);
        return object;
    }

    public static class LogFile
    extends RandomAccessFile {
        private final FileDescriptor fd = this.getFD();

        public LogFile(String string, String string2) throws FileNotFoundException, IOException {
            super(string, string2);
        }

        protected void sync() throws IOException {
            this.fd.sync();
        }

        protected boolean checkSpansBoundary(long l) {
            return l % 512L > 508L;
        }
    }
}

