/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    final long[] hb;
    final int offset;
    boolean isReadOnly;

    LongBuffer(int n, int n2, int n3, int n4, long[] lArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = lArray;
        this.offset = n5;
    }

    LongBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static LongBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapLongBuffer(n, n);
    }

    public static LongBuffer wrap(long[] lArray, int n, int n2) {
        try {
            return new HeapLongBuffer(lArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public LongBuffer get(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            lArray[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = longBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(longBuffer.get());
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        LongBuffer.checkBounds(n, n2, lArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(lArray[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final long[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract LongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongBuffer)) {
            return false;
        }
        LongBuffer longBuffer = (LongBuffer)object;
        int n = this.position();
        int n2 = this.limit();
        int n3 = longBuffer.position();
        int n4 = longBuffer.limit();
        int n5 = n2 - n;
        int n6 = n4 - n3;
        if (n5 < 0 || n5 != n6) {
            return false;
        }
        int n7 = n2 - 1;
        int n8 = n4 - 1;
        while (n7 >= n) {
            if (!LongBuffer.equals(this.get(n7), longBuffer.get(n8))) {
                return false;
            }
            --n7;
            --n8;
        }
        return true;
    }

    private static boolean equals(long l, long l2) {
        return l == l2;
    }

    @Override
    public int compareTo(LongBuffer longBuffer) {
        int n = this.position();
        int n2 = this.limit() - n;
        int n3 = longBuffer.position();
        int n4 = longBuffer.limit() - n3;
        int n5 = Math.min(n2, n4);
        if (n5 < 0) {
            return -1;
        }
        int n6 = n + Math.min(n2, n4);
        int n7 = n;
        int n8 = n3;
        while (n7 < n6) {
            int n9 = LongBuffer.compare(this.get(n7), longBuffer.get(n8));
            if (n9 != 0) {
                return n9;
            }
            ++n7;
            ++n8;
        }
        return n2 - n4;
    }

    private static int compare(long l, long l2) {
        return Long.compare(l, l2);
    }

    public abstract ByteOrder order();
}

