/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListORBs
implements CommandHandler {
    static final int illegalServerId = -1;

    ListORBs() {
    }

    @Override
    public String getCommandName() {
        return "orblist";
    }

    @Override
    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.orbidmap"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.orbidmap1"));
        }
    }

    @Override
    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            String[] stringArray2 = activator.getORBNames(n);
            printStream.println(CorbaResourceUtil.getText("servertool.orbidmap2"));
            for (int i = 0; i < stringArray2.length; ++i) {
                printStream.println("\t " + stringArray2[i]);
            }
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println("\tno such server found.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

