/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.CallJavaNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class CallStaticJavaNode
extends CallJavaNode {
    private static AddressField nameField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CallStaticJavaNode");
        nameField = type.getAddressField("_name");
    }

    public String name() {
        return CStringUtilities.getString(nameField.getValue(this.getAddress()));
    }

    public CallStaticJavaNode(Address addr) {
        super(addr);
    }

    @Override
    public void dumpSpec(PrintStream out) {
        out.print(" Static ");
        String name = this.name();
        if (name != null) {
            out.print(name);
            out.print(" ");
        }
        super.dumpSpec(out);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CallStaticJavaNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

