/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeGetPut;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodePutStatic
extends BytecodeGetPut {
    BytecodePutStatic(Method method, int bci) {
        super(method, bci);
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check putstatic");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 179;
    }

    public static BytecodePutStatic at(Method method, int bci) {
        BytecodePutStatic b = new BytecodePutStatic(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodePutStatic atCheck(Method method, int bci) {
        BytecodePutStatic b = new BytecodePutStatic(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodePutStatic at(BytecodeStream bcs) {
        return new BytecodePutStatic(bcs.method(), bcs.bci());
    }
}

