/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class G1MonitoringSupport
extends VMObject {
    private static CIntegerField edenCommittedField;
    private static CIntegerField edenUsedField;
    private static CIntegerField survivorCommittedField;
    private static CIntegerField survivorUsedField;
    private static CIntegerField oldCommittedField;
    private static CIntegerField oldUsedField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("G1MonitoringSupport");
        edenCommittedField = type.getCIntegerField("_eden_committed");
        edenUsedField = type.getCIntegerField("_eden_used");
        survivorCommittedField = type.getCIntegerField("_survivor_committed");
        survivorUsedField = type.getCIntegerField("_survivor_used");
        oldCommittedField = type.getCIntegerField("_old_committed");
        oldUsedField = type.getCIntegerField("_old_used");
    }

    public long edenCommitted() {
        return edenCommittedField.getValue(this.addr);
    }

    public long edenUsed() {
        return edenUsedField.getValue(this.addr);
    }

    public long edenRegionNum() {
        return this.edenUsed() / HeapRegion.grainBytes();
    }

    public long survivorCommitted() {
        return survivorCommittedField.getValue(this.addr);
    }

    public long survivorUsed() {
        return survivorUsedField.getValue(this.addr);
    }

    public long survivorRegionNum() {
        return this.survivorUsed() / HeapRegion.grainBytes();
    }

    public long oldCommitted() {
        return oldCommittedField.getValue(this.addr);
    }

    public long oldUsed() {
        return oldUsedField.getValue(this.addr);
    }

    public G1MonitoringSupport(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                G1MonitoringSupport.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

