/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class VerboseGC {
    private MBeanServerConnection server;
    private JMXConnector jmxc;

    public VerboseGC(String string, int n) {
        System.out.println("Connecting to " + string + ":" + n);
        String string2 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        this.connect(string2);
    }

    public void dump(long l, long l2) {
        try {
            PrintGCStat printGCStat = new PrintGCStat(this.server);
            int n = 0;
            while ((long)n < l2) {
                printGCStat.printVerboseGc();
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    System.exit(1);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
    }

    private void connect(String string) {
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string);
            this.jmxc = JMXConnectorFactory.connect(jMXServiceURL);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            VerboseGC.usage();
        }
        String string = "";
        int n = -1;
        long l = 5000L;
        long l2 = 5L;
        for (String string2 : stringArray) {
            if (string2.startsWith("-")) {
                if (string2.equals("-h") || string2.equals("-help") || string2.equals("-?")) {
                    VerboseGC.usage();
                    continue;
                }
                if (string2.startsWith("-interval=")) {
                    try {
                        l = Integer.parseInt(string2.substring(10)) * 1000;
                    }
                    catch (NumberFormatException numberFormatException) {
                        VerboseGC.usage();
                    }
                    continue;
                }
                if (string2.startsWith("-duration=")) {
                    try {
                        l2 = Integer.parseInt(string2.substring(10));
                    }
                    catch (NumberFormatException numberFormatException) {
                        VerboseGC.usage();
                    }
                    continue;
                }
                System.err.println("Unrecognized option: " + string2);
                VerboseGC.usage();
                continue;
            }
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) {
                VerboseGC.usage();
            }
            string = stringArray2[0];
            try {
                n = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                VerboseGC.usage();
            }
            if (n >= 0) continue;
            VerboseGC.usage();
        }
        VerboseGC verboseGC = new VerboseGC(string, n);
        long l3 = l2 * 60L * 1000L / l;
        verboseGC.dump(l, l3);
    }

    private static void usage() {
        System.out.print("Usage: java VerboseGC <hostname>:<port> ");
        System.out.println(" [-interval=seconds] [-duration=minutes]");
    }
}

