/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.rrd4j.core.ByteBufferBackend;

public class RrdMemoryBackend
extends ByteBufferBackend {
    private final AtomicReference<ByteBuffer> refbb;

    protected RrdMemoryBackend(String path, AtomicReference<ByteBuffer> refbb) {
        super(path);
        this.refbb = refbb;
        Optional.ofNullable(refbb).map(AtomicReference::get).ifPresent(this::setByteBuffer);
    }

    @Override
    protected void setLength(long length) {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal length: " + length);
        }
        this.refbb.set(ByteBuffer.allocate((int)length));
        this.setByteBuffer(this.refbb.get());
    }

    @Override
    public long getLength() {
        return Optional.ofNullable(this.refbb.get()).map(Buffer::capacity).orElse(0).intValue();
    }

    @Override
    protected void close() {
    }
}

