# GNU Typist - improved typing tutor program for UNIX systems
#
# Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003  Simon Baldwin
# Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
#               2012, 2013, 2014, 2016, 2017, 2018, 2019, 2020
#               Felix Natter, Paul Goins, Tim Marston, Mihai Gătejescu
# Copyright (C) 2021, 2022, 2023, 2024 Felix Natter, Mihai Gătejescu
#
# GNU Typist is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# GNU Typist is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Typist.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series S
#------------------------------------------------------------------------------
G:_S_MENU
*:_S_NO_MENU

#------------------------------------------------------------------------------
# Lesson S1
#------------------------------------------------------------------------------
*:S1
*:_S_S_S1
B:                             Lesson S1

*:_S_R_L0
T:			SPEED PRACTICE SERIES
 :
 :The S series of lessons is designed to help you improve your typing speed
 :and accuracy.  It is assumed that you have already learned how to touch
 :type either from a previous course in touch typing or from the T series of
 :these lessons.
 :
 :You can use this series even if you do not know how to touch type.  But, it is
 :recommended that you at least learn to touch type most of the letters of the
 :alphabet before starting this series.  When you encounter a letter or symbol
 :which you have not learned, you will have to look.  This is a very bad habit to
 :get into and is hard to break.  (You needn't worry if you only need to glance
 :down for unusual keys, like the dollar sign.)

*:_S_R_L1
T:			   RULES OF THE GAME
 :
 :I will display a paragraph on the screen.  You should then type the entire
 :paragraph as quickly and as accurately as possible.   As you type each
 :character, I will immediately check it for accuracy.  If it was right, I won't
 :do anything.  But, if you made a mistake, I will beep and write that letter in
 :inverse video (a black character on a white background).  You can ignore the
 :error and continue going; or, you can backup and correct it with the DELETE
 :or BACKSPACE keys.  (I will still count it as an error though.)
 :
 :I will also be timing you.  From the time you type the first character until
 :you hit the final carriage return, my stop watch will be going.  At the
 :end of the paragraph, I will tell you your rating (in words-per-minute).
 :
 :If you made too many mistakes, try the next paragraph slower.  If you made no
 :mistakes or only one or two, try the next one faster.

I:First, a quick warm-up.
*:_S_R_L2
S:The quick brown fox jumped over the lazy dogs.

I:Once more:
*:_S_R_L3
S:The quick brown fox jumped over the lazy dogs.

I:If the cursor is on a blank line, type return to skip it
*:_S_R_L4
S:Dear Sirs:
 :
 :I have just purchased a Heathkit H89 computer system and would
 :like to order two boxes of diskettes for it.  This system uses
 :5 1/4 inch, hard-sectored, ten-sector, single-sided, single-
 :density diskettes.
 :
 :Enclosed is my check for $45.00.  Please rush this order, as I
 :can not use my system before they arrive.
 :
 :Sincerely,
 :
 :Mr. Smith

*:_S_R_L5
S:Dear Sirs:
 :
 :Thank you for sending the diskettes so promptly.  How-
 :ever, the diskettes which you sent are for soft-sectored
 :drives.  As I stated in my original letter my system
 :accepts only ten-sector, hard-sectored diskettes.
 :
 :I will return these two boxes as soon as I receive the
 :correct ones.
 :
 :Sincerely,
 :
 :Mr. Smith

*:_S_R_L6
S:Dear Mr. Smith:
 :
 :Thank you for informing us that the diskettes which you pur-
 :chased from us are not satisfactory.  We are sorry for the
 :inconvenience you have been caused in this transaction.
 :
 :We shall be glad to replace the diskettes you now have or to
 :allow you to select a different brand.  If you will let us know
 :your wishes we shall be glad to give the matter our immediate
 :attention.
 :
 :We hope you will give us the opportunity to prove to you that
 :this incident is most unusual and that we do strive to render
 :to our customers an efficient and courteous service at all
 :times.

G:_S_E_S1

#------------------------------------------------------------------------------
# Lesson S2
#------------------------------------------------------------------------------
*:S2
*:_S_S_S2
B:                             Lesson S2

*:_S_R_L7
T:
 :In this lesson we will practice some quotes by some famous (and not
 :so famous) people.

I:Marcus Aurelius
*:_S_R_L8
S:A man can live well even in a palace.

I:Ralph Waldo Emerson
*:_S_R_L9
S:My chief want in life is someone who shall make me do what I can.

I:Elizabeth Barrett Browning
*:_S_R_L10
S:No man can be called friendless when he has God and the
 :companionship of good books.

I:Ralph Waldo Emerson
*:_S_R_L11
S:I like the silent church before the service begins better than any preaching.

I:George Washington
*:_S_R_L12
S:True friendship is a plant of slow growth.

I:Aristotle
*:_S_R_L13
S:There is a foolish corner in the brain of the wisest men.

I:Goethe
*:_S_R_L14
S:Tell me what you are busy about, and I will tell you what you are.

I:Gelett Burgess
*:_S_R_L15
S:If in the last few years you haven't discarded a major opinion or
 :acquired a new one, check your pulse.  You may be dead.

I:James B. Conant
*:_S_R_L16
S:Democracy is a small hard core of common agreement, surrounded
 :by a rich variety of individual differences.

I:Albert Einstein
*:_S_R_L17
S:I never think of the future.  It comes soon enough.

I:Harry S. Truman
*:_S_R_L18
S:Men often mistake notoriety for fame, and would rather be
 :remarked for their vices than not be noticed at all.

I:Will Rogers
*:_S_R_L19
S:I could study all my life and not think up half the amount
 :of funny things they can think of in one session of Congress.

I:Ralph Waldo Emerson
*:_S_R_L20
S:Hospitality consists in a little fire, a little food and an immense quiet.

I:H. L. Mencken
*:_S_R_L21
S:Puritanism is the haunting fear that someone, somewhere, may be happy.

I:William James
*:_S_R_L22
S:When you have to make a choice and don't make it, that is in itself a choice.

I:James Holt McGravran.
*:_S_R_L23
S:There is a way of transferring funds that is even faster
 :than electronic banking.  It is called marriage.

I:Woody Allen
*:_S_R_L24
S:Showing up is 80 percent of life.

I:Robert Frost
*:_S_R_L25
S:A poem begins in delight and ends in wisdom.

I:Louis Pasteur
*:_S_R_L26
S:When I approach a child, he inspires in me two sentiments:  tenderness
 :for what he is, and respect for what he may become.

I:E. Joseph Crossman
*:_S_R_L27
S:The best bridge between despair and hope is a good night's sleep.

G:_S_E_S2

#------------------------------------------------------------------------------
# Lesson S3
#------------------------------------------------------------------------------
*:S3
*:_S_S_S3
B:                             Lesson S3

*:_S_R_L28
T:
 :In this lesson you will be given several excerpts from the classics.
 :Take your time and type them carefully.

I:A Christmas Carol, Stave One, Marley's Ghost
*:_S_R_L29
S:Now, it is a fact, that there was nothing at all par-
 :ticular about the knocker on the door, except that it
 :was very large.  It is also a fact, that Scrooge had
 :seen it, night and morning, during his whole residence
 :in that place; also that Scrooge has as little of what
 :is called fancy about him as any man in the city of
 :London, even including--which is a bold word--the
 :corporation, aldermen, and livery.  Let it also be
 :borne in mind that Scrooge had not bestowed one
 :thought on Marley, since his last mention of his
 :seven year's dead partner that afternoon.  And then
 :let any man explain to me, if he can, how it happened
 :that Scrooge, having his key in the lock of the door,
 :saw in the knocker, without its undergoing any inter-
 :mediate process of change--not a knocker, but Mar-
 :ley's face.

I:Gulliver's Travels, Chapter One, A Voyage to Lilliput
*:_S_R_L30
S:When I awaked it was just daylight.  I attempted to rise, but I
 :found my arms and legs were strongly fastened on each side to
 :the ground; and my hair, which was long and thick, tied to the
 :ground in the same manner.  I likewise felt several slender
 :ligatures across my body, from my armpits to my thighs.  I
 :could only look upward; the sun began to grow hot, and the
 :light offended my eyes.  I heard a confused noise about me;
 :but in the posture I lay could see nothing except the sky.  In a
 :little time I felt something alive moving on my left leg,
 :which, advancing gently forward over my breast, came almost up
 :to my chin; when bending my eyes downward as much as I could, I
 :perceived it to be a human creature not six inches high, with a
 :bow and arrow in his hands, and a quiver at his back.  In the
 :mean time I felt at least forty more of the same kind (as I
 :conjectured) following the first.

I:Treasure Island, Chapter IV, "The Sea Chest", by Stevenson.
*:_S_R_L31
S:I lost no time, of course, in telling my mother all that
 :I knew, and perhaps should have told her long before,
 :and we saw ourselves at once in a difficult and dangerous
 :position.  Some of the man's money--if he had any--was
 :certainly due to us; but it was not likely that our
 :captain's shipmates, above all the two specimens seen by
 :me, Black Dog and the blind beggar, would be inclined to
 :give up their booty in payment of the dead man's debts.
 :The captain's order to mount at once and ride for Dr.
 :Livesey would have left my mother alone and unprotected,
 :which was not to be thought of.  Indeed, it seemed
 :impossible for either of us to remain much longer in the
 :house:  the fall of coals in the kitchen grate, the very
 :ticking of the clock, filled us with alarms.

I:Treasure Island, Chapter IV, "The Sea Chest", by Stevenson.
*:_S_R_L32
S:The neighborhood, to our ears, seemed haunted by
 :approaching footsteps; and what between the dead
 :body of the captain on the parlor floor, and the thought
 :of that detestable blind beggar hovering near at hand,
 :and ready to return, there were moments when, as the
 :saying goes, I jumped in my skin for terror.  Something
 :must speedily be resolved upon; and it occurred to us at
 :last to go forth together and seek help in the neighbor-
 :ing hamlet.  No sooner said than done.  Bareheaded as we
 :were, we ran out at once in the gathering evening and
 :the frosty fog.

G:_S_E_S3

#------------------------------------------------------------------------------
# Lesson S4
#------------------------------------------------------------------------------
*:S4
*:_S_S_S4
B:                             Lesson S4

*:_S_R_L33
T:
 :In this lesson you will be given several soliloquies from
 :Shakespeare's plays.  The spelling and punctuation are
 :quite hard.  Take your time and type them carefully.

I:Romeo and Juliet, Act II, Scene II (Capulet's Garden 1/2)
*:_S_R_L34
S:But, soft! what light through yonder window breaks?
 :It is the east, and Juliet is the sun!--
 :Arise, fair sun, and kill the envious moon,
 :Who is already sick and pale with grief,
 :That thou her maid art far more fair than she:
 :Be not her maid, since she is envious;
 :Her vestal livery is but sick and green,
 :And none but fools do wear it; cast it off.--
 :It is my lady; O, it is my love!
 :O, that she knew she were!--
 :She speaks, yet she says nothing:  what of that?
 :Her eye discourses, I will answer it.--
 :I am too bold, 'tis not to me she speaks:

I:Romeo and Juliet, Act II, Scene II (Capulet's Garden 2/2)
*:_S_R_L35
S:Two of the fairest stars in all the heaven,
 :Having some business, do entreat her eyes
 :To twinkle in their spheres till they return.
 :What if her eyes were there, they in her head?
 :The brightness of her cheek would shame those stars,
 :As daylight doth a lamp; her eyes in heaven
 :Would through the airy region stream so bright
 :That birds would sing, and think it were not night.--
 :See how she leans her cheek upon her hand!
 :O, that I were a glove upon that hand,
 :That I might touch that cheek!

I:Julius Caesar, Act III, Scene II (The Forum 1/3)
*:_S_R_L36
S:Friends, Romans, countrymen, lend me your ears;
 :I come to bury Caesar, not to praise him.
 :The evil that men do lives after them;
 :The good is oft interred with their bones;
 :So let it be with Caesar:  The noble Brutus
 :Hath told you Caesar was ambitious:
 :If it were so, it was a grievous fault;
 :And grievously hath Caesar answer'd it.
 :Here, under leave of Brutus and the rest,--
 :For Brutus is an honourable man;
 :So are they all, all honourable men,--
 :Come I to speak in Caesar's funeral.
 :He was my friend, faithful and just to me;
 :But Brutus says he was ambitious;
 :And Brutus is an honourable man.

I:Julius Caesar, Act III, Scene II (The Forum 2/3)
*:_S_R_L37
S:He hath brought many captives home to Rome.
 :Whose ransoms did the general coffers fill:
 :Did this in Caesar seem ambitious?
 :When that the poor have cried, Caesar hath wept:
 :Ambition should be made of sterner stuff:
 :Yet Brutus says he was ambitious;
 :And Brutus is an honourable man.
 :You all did see that on the Lupercal
 :I thrice presented him a kingly crown,
 :Which he did thrice refuse:  was this ambition?
 :Yet Brutus says he was ambitious;
 :And, sure, he is an honourable man.

I:Julius Caesar, Act III, Scene II (The Forum 3/3)
*:_S_R_L38
S:I speak not to disprove what Brutus spoke,
 :But here I am to speak what I do know.
 :You all did love him once,--not without cause:
 :What cause withholds you, then, to mourn for him?
 :O judgement, thou art fled to brutish beasts,
 :And men have lost their reason!--Bear with me;
 :My heart is in the coffin there with Caesar,
 :And I must pause till it come back to me.

I:The Merchant of Venice, Act IV, Scene I (A Court of Justice 1/2)
*:_S_R_L39
S:The quality of mercy is not strain'd;
 :It droppeth as the gentle rain from heaven
 :Upon the place beneath: it is twice bless'd;
 :It blesseth him that gives and him that takes:
 :'Tis mightiest in the mightiest; it becomes
 :The throned monarch better than his crown;
 :His sceptre shows the force of temporal power,
 :The attribute to awe and majesty,
 :Wherein doth sit the dread and fear of kings;

I:The Merchant of Venice, Act IV, Scene I (A Court of Justice 2/2)
*:_S_R_L40
S:But mercy is above this scepter'd sway,--
 :It is enthroned in the heart of kings,
 :It is an attribute to God himself;
 :And earthly power doth then show likest God's
 :When mercy seasons justice.  Therefore, Jew,
 :Though justice be thy plea consider this--
 :That in the course of justice none of us
 :Should see salvation: we do pray for mercy;
 :And that same prayer doth teach us all to render
 :The deeds of mercy.  I have spoke thus much
 :To mitigate the justice of thy plea;
 :Which if thou follow, this strict court of Venice
 :Must needs give sentence 'gainst the merchant there.

I:The Tempest, Act III, Scene I (Before Prospero's cell)
*:_SR_L41
S:There be some sports are painful, and their labour
 :Delight in them sets off: some kinds of baseness
 :Are nobly undergone, and most poor matters
 :Point to rich ends. This my mean task
 :Would be as heavy to me as odious, but
 :The mistress which I serve quickens what's dead,
 :And makes my labours pleasures: O, she is
 :Ten times more gentle than her father's crabbed.
 :And he's composed of harshness. I must remove
 :Some thousands of these logs, and pile them up,
 :Upon a sore injunction: my sweet mistress
 :Weeps when she sees me work, and says, such baseness
 :Had never like executor. I forget:
 :But these sweet thoughts do even refresh my labours,
 :Most busy lest, when I do it.

I:The Tempest, Act IV, Scene I (Before Prospero's cell)
*:_SR_L42
S:You do look, my son, in a moved sort,
 :As if you were dismay'd: be cheerful, sir.
 :Our revels now are ended. These our actors,
 :As I foretold you, were all spirits, and
 :Are melted into air, into thin air:
 :And, like the baseless fabric of this vision,
 :The cloud-capp'd towers, the gorgeous palaces,
 :The solemn temples, the great globe itself,
 :Yea, all which it inherit, shall dissolve,
 :And, like this insubstantial pageant faded,
 :Leave not a rack behind. We are such stuff
 :As dreams are made on; and our little life
 :Is rounded with a sleep. Sir, I am vex'd;
 :Bear with my weakness; my old brain is troubled:
 :Be not disturb'd with my infirmity:
 :If you be pleased, retire into my cell,
 :And there repose: a turn or two I'll walk,
 :To still my beating mind.

I:The Tempest, Act V, Scene I (Before Prospero's cell)
*:_SR_L43
S:But this rough magic
 :I here abjure; and, when I have required
 :Some heavenly music,--which even now I do,--
 :To work mine end upon their senses, that
 :This airy charm is for, I'll break my staff,
 :Bury it certain fathoms in the earth,
 :And deeper than did ever plummet sound
 :I'll drown my book.

I:Hamlet, Act III, Scene I, (A room in the castle 1/3)
*:_SR_L44
S:To be, or not to be, that is the question:
 :Whether 'tis nobler in the mind to suffer
 :The slings and arrows of outrageous fortune,
 :Or to take arms against a sea of troubles,
 :And, by opposing end them?--To die,--to sleep,
 :No more;--and by a sleep, to say we end
 :The heart-ache, and the thousand natural shocks
 :That flesh is heir to: 'tis a consummation
 :Devoutly to be wished. To die,--to sleep,--
 :To sleep! perchance to dream: ay, there's the rub;
 :For in that sleep of death what dreams may come,
 :When we have shuffled off this mortal coil,
 :Must give us pause: There's the respect
 :That makes calamity of so long life;

I:Hamlet, Act III, Scene I, (A room in the castle 2/3)
*:_SR_L45
S:For who would bear the whips and scorns of time,
 :The oppressor's wrong, the proud man's contumely,
 :The pangs of despised love, the law's delay,
 :The insolence of office, and the spurns
 :That patient merit of the unworthy takes,
 :When he himself might his quietus make
 :With a bare bodkin? Who would fardels bear,
 :To groan and sweat under a weary life
 :But that the dread of something after death,
 :The undiscovered country, from whose bourn
 :No traveller returns, puzzles the will,
 :And makes us rather bear those ills we have
 :Than fly to others that we know not of?

I:Hamlet, Act III, Scene I, (A room in the castle 3/3)
*:_SR_L46
S:Thus, conscience does make cowards of us all;
 :And thus, the native hue of resolution
 :Is sicklied o'er with the pale cast of thought;
 :And enterprises of great pith and moment,
 :With this regard, their currents turn away,
 :And lose the name of action. Soft you now!
 :The fair Ophelia:--Nymph, in thy orisons
 :Be all my sins remember'd.

G:_S_E_S4

#------------------------------------------------------------------------------
# Lesson series S jump tables
#------------------------------------------------------------------------------
*:_S_E_S1
Q: Do you want to continue to lesson S2 [Y/N] ?
N:_S_MENU
G:_S_S_S2
*:_S_E_S2
Q: Do you want to continue to lesson S3 [Y/N] ?
N:_S_MENU
G:_S_S_S3
*:_S_E_S3
Q: Do you want to continue to lesson S4 [Y/N] ?
N:_S_MENU
G:_S_S_S4
*:_S_E_S4
G:_S_MENU

#------------------------------------------------------------------------------
# Lesson series S menu
#------------------------------------------------------------------------------
*:_S_MENU
B:                          Speed drills
M: UP=_EXIT "The S series contains the following 4 lessons"
 :_S_S_S1 "Lesson S1     Speed tests"
 :_S_S_S2 "Lesson S2     Speed tests"
 :_S_S_S3 "Lesson S3     Speed tests"
 :_S_S_S4 "Lesson S4     Speed tests"
*:_S_EXIT
#------------------------------------------------------------------------------
