/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import twitter4j.TwitterException;
import twitter4j.auth.OAuthToken;
import twitter4j.internal.http.HttpResponse;

public class AccessToken
extends OAuthToken
implements Serializable {
    private static final long serialVersionUID = -8344528374458826291L;
    private String screenName;
    private long userId;

    AccessToken(HttpResponse res) throws TwitterException {
        this(res.asString());
    }

    AccessToken(String str) {
        super(str);
        this.screenName = this.getParameter("screen_name");
        String sUserId = this.getParameter("user_id");
        if (sUserId != null) {
            this.userId = Long.parseLong(sUserId);
        }
    }

    public AccessToken(String token, String tokenSecret) {
        super(token, tokenSecret);
        String sUserId;
        try {
            sUserId = token.substring(0, token.indexOf("-"));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid access token format.");
        }
        if (sUserId != null) {
            this.userId = Long.parseLong(sUserId);
        }
    }

    public String getScreenName() {
        return this.screenName;
    }

    public long getUserId() {
        return this.userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.userId != that.userId) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    public String toString() {
        return "AccessToken{screenName='" + this.screenName + '\'' + ", userId=" + this.userId + '}';
    }

    public /* synthetic */ String getParameter(String x0) {
        return super.getParameter(x0);
    }

    public /* synthetic */ String getTokenSecret() {
        return super.getTokenSecret();
    }

    public /* synthetic */ String getToken() {
        return super.getToken();
    }
}

