
local function charAt(s, i)
    return string.sub(s, i, i)
end
    
local function moveXY(model, symbols, destX, destY)
    -- symbol is e.g. 'UDLR'
    local result = false
    local locX, locY = model:getLoc()
    local w = model:getW()
    local h = model:getH()

    --print("TEST: move '"..symbols.."' "..locX..","..locY.." -> "..destX..","..destY)

    --TODO: find undirect path too
    if locX > destX and isWater(locX - 1, locY) then
        level_action_move(charAt(symbols, 3))
    elseif locX < destX and isWater(locX + w, locY) then
        level_action_move(charAt(symbols, 4))
    elseif locY > destY and isWater(locX, locY - 1) then
        level_action_move(charAt(symbols, 1))
    elseif locY < destY and isWater(locX, locY + h) then
        level_action_move(charAt(symbols, 2))
    else
        if locX ~= destX or locY ~= destY then
            error("moveXY - fish cannot move")
        end
        result = true
    end
    return result
end
local function bigMoveXY(x, y)
    return moveXY(big, 'UDLR', x, y)
end
local function smallMoveXY(x, y)
    return moveXY(small, 'udlr', x, y)
end
local function planDelay(delay)
    level_planShow(function(count)
        return count >= delay
    end)
end

local function showMove(move)
    level_planShow(function(count)
        return level_action_move(move)
    end)
end

--TODO: F1 for How to Play manual
-- ---------------------------------------------------------------
level_planShow(function(count)
    addm(0, "help1")
    return true
end)
planDelay(3)
-- line 9
level_planShow(function(count)
    return smallMoveXY(17, 25)
end)
planDelay(3)
planDelay(3)
-- line 49
showMove('L')
showMove('L')
showMove('L')
level_planShow(function(count)
    addv(0, "help2")
    return true
end)
level_planShow(function(count)
    return bigMoveXY(18, 21)
end)
showMove('D')
showMove('L')
showMove('D')
-- line 63
planDelay(1)
planDelay(27)
-- line 136
planDelay(18)
-- line 171
level_planShow(function(count)
    return level_action_save()
end)
planDelay(6)
-- line 185
level_planShow(function(count)
    return smallMoveXY(9, 25)
end)
level_planShow(function(count)
    addm(0, "help3")
    return true
end)
planDelay(1)
showMove('u')
showMove('u')
showMove('l')
showMove('l')
level_planShow(function(count)
    return smallMoveXY(7, 17)
end)
planDelay(3)
-- line 231
showMove('r')
planDelay(5)
-- line 231
level_planShow(function(count)
    addv(0, "help4")
    return true
end)
planDelay(7)
planDelay(3)
-- line 265
showMove('L')
showMove('L')
showMove('L')
showMove('L')
planDelay(13)
-- line 301
level_planShow(function(count)
    addm(0, "help5")
    return true
end)
planDelay(7)
planDelay(10)
-- line 337
showMove('r')
planDelay(13)
showMove('r')
planDelay(3)
showMove('r')
planDelay(13)
-- line 401
showMove('l')
showMove('l')
showMove('l')
level_planShow(function(count)
    addm(0, "help6")
    return true
end)
showMove('d')
showMove('d')
showMove('r')
showMove('r')
level_planShow(function(count)
    return smallMoveXY(9, 25)
end)
planDelay(1)
level_planShow(function(count)
    return smallMoveXY(7, 25)
end)
planDelay(6)
-- line 453
showMove('u')
showMove('u')
showMove('u')
showMove('u')
planDelay(19)
-- line 499
showMove('d')
planDelay(39)
-- line 579
level_planShow(function(count)
    return level_action_restart()
end)
planDelay(11)
level_planShow(function(count)
    addv(0, "help7")
    return true
end)
planDelay(66)
-- line 729
level_planShow(function(count)
    return level_action_load()
end)
planDelay(8)
level_planShow(function(count)
    addv(0, "help8")
    return true
end)
planDelay(7)
planDelay(29)
-- line 781
level_planShow(function(count)
    return bigMoveXY(9, 23)
end)
showMove('D')
showMove('D')
showMove('L')
showMove('L')
level_planShow(function(count)
    return bigMoveXY(7, 30)
end)
showMove('R')
showMove('R')
showMove('R')
planDelay(3)
-- line 831
showMove('U')
planDelay(3)
level_planShow(function(count)
    addm(0, "help9")
    return true
end)
planDelay(3)
showMove('U')
planDelay(5)
planDelay(10)
-- line 881
showMove('l')
planDelay(26)
showMove('l')
planDelay(3)
-- line 943
level_planShow(function(count)
    return smallMoveXY(7, 25)
end)
planDelay(3)
level_planShow(function(count)
    addm(0, "help10")
    return true
end)
planDelay(5)
showMove('u')
showMove('u')
showMove('u')
showMove('u')
showMove('u')
showMove('u')
showMove('u')
planDelay(16)
-- line 1009
showMove('l')
planDelay(25)
showMove('l')
planDelay(44)
-- line 1151
level_planShow(function(count)
    return level_action_restart()
end)
planDelay(12)
level_planShow(function(count)
    addv(0, "help11")
    return true
end)
planDelay(39)
level_planShow(function(count)
    return level_action_load()
end)
planDelay(4)
planDelay(5)
-- line 1277
level_planShow(function(count)
    return bigMoveXY(9, 23)
end)
showMove('D')
showMove('D')
showMove('L')
showMove('L')
level_planShow(function(count)
    return bigMoveXY(7, 30)
end)
showMove('R')
showMove('R')
showMove('R')
planDelay(2)
-- line 1325
showMove('U')
planDelay(1)
showMove('U')
planDelay(6)
planDelay(3)
level_planShow(function(count)
    addm(0, "help12")
    return true
end)
planDelay(4)
-- line 1359
showMove('l')
showMove('u')
showMove('l')
showMove('u')
planDelay(1)
level_planShow(function(count)
    return smallMoveXY(8, 23)
end)
planDelay(1)
level_planShow(function(count)
    return smallMoveXY(8, 17)
end)
planDelay(7)
showMove('r')
planDelay(8)
showMove('r')
planDelay(3)
showMove('r')
-- line 1436
showMove('r')
showMove('r')
showMove('r')
showMove('d')
showMove('d')
showMove('r')
showMove('d')
showMove('d')
showMove('d')
planDelay(1)
showMove('r')
showMove('r')
showMove('r')
level_planShow(function(count)
    return smallMoveXY(17, 25)
end)
-- line 1469
level_planShow(function(count)
    addm(0, "help13")
    return true
end)
planDelay(7)
showMove('d')
planDelay(22)
-- line 1531
showMove('l')
showMove('l')
showMove('l')
planDelay(11)
showMove('r')
showMove('r')
showMove('d')
planDelay(2)
-- line 1569
showMove('l')
showMove('l')
showMove('l')
showMove('l')
planDelay(45)
-- line 1667
level_planShow(function(count)
    return level_action_restart()
end)
planDelay(8)
level_planShow(function(count)
    return level_action_load()
end)
planDelay(4)
level_planShow(function(count)
    addv(0, "help14")
    return true
end)
planDelay(10)
-- line 1717
level_planShow(function(count)
    return smallMoveXY(7, 25)
end)
planDelay(5)
showMove('l')
planDelay(13)
level_planShow(function(count)
    addm(0, "help15")
    return true
end)
showMove('u')
showMove('u')
showMove('u')
planDelay(7)
-- line 1815
showMove('r')
showMove('r')
showMove('r')
showMove('r')
planDelay(5)
planDelay(2)
showMove('L')
showMove('D')
showMove('D')
planDelay(2)
-- line 1847
showMove('L')
showMove('L')
showMove('L')
showMove('L')
showMove('L')
planDelay(1)
-- line 1857
showMove('L')
showMove('L')
showMove('L')
showMove('L')
showMove('D')
showMove('D')
showMove('D')
showMove('D')
showMove('D')
showMove('R')
showMove('R')
showMove('R')
-- line 1895
showMove('U')
planDelay(2)
level_planShow(function(count)
    addm(0, "help16")
    return true
end)
planDelay(6)
planDelay(4)
-- line 1923
showMove('d')
showMove('d')
showMove('d')
showMove('l')
showMove('l')
showMove('d')
showMove('d')
planDelay(7)
-- line 1955
showMove('r')
planDelay(29)
showMove('r')
planDelay(3)
-- line 2023
level_planShow(function(count)
    return smallMoveXY(4, 27)
end)
showMove('d')
showMove('d')
showMove('d')
planDelay(4)
planDelay(3)
showMove('U')
planDelay(2)
showMove('U')
planDelay(6)
planDelay(4)
-- line 2083
level_planShow(function(count)
    return smallMoveXY(10, 30)
end)
showMove('u')
showMove('r')
level_planShow(function(count)
    addm(0, "help17")
    return true
end)
planDelay(11)
planDelay(8)
showMove('L')
showMove('L')
showMove('L')
planDelay(8)
-- line 2163
showMove('D')
level_planShow(function(count)
    return bigMoveXY(3, 28)
end)
planDelay(5)
planDelay(6)
level_planShow(function(count)
    addm(0, "help18")
    return true
end)
planDelay(4)
-- 2205
level_planShow(function(count)
    return smallMoveXY(7, 29)
end)
level_planShow(function(count)
    return smallMoveXY(7, 25)
end)
showMove('l')
planDelay(3)
showMove('u')
planDelay(6)
showMove('d')
planDelay(6)
showMove('u')
showMove('u')
showMove('u')
showMove('u')
showMove('u')
planDelay(4)
showMove('u')
planDelay(4)
showMove('l')
planDelay(5)
-- line 2301
showMove('r')
showMove('r')
showMove('r')
showMove('r')
showMove('u')
showMove('u')
planDelay(5)
showMove('r')
showMove('r')
planDelay(4)
planDelay(3)
-- line 2343
level_planShow(function(count)
    return bigMoveXY(8, 28)
end)
showMove('D')
showMove('R')
planDelay(5)
showMove('U')
planDelay(1)
showMove('U')
showMove('U')
planDelay(11)
planDelay(3)
level_planShow(function(count)
    addm(0, "help19")
    return true
end)
planDelay(4)
-- line 2421
showMove('l')
showMove('l')
showMove('l')
showMove('d')
showMove('d')
planDelay(1)
showMove('r')
showMove('r')
showMove('r')
showMove('d')
showMove('d')
showMove('d')
planDelay(8)
-- line 2461
showMove('r')
planDelay(2)
showMove('r')
level_planShow(function(count)
    return smallMoveXY(6, 22)
end)
level_planShow(function(count)
    return smallMoveXY(6, 28)
end)
planDelay(1)
level_planShow(function(count)
    return smallMoveXY(14, 28)
end)
showMove('u')
showMove('r')
showMove('r')
showMove('r')
level_planShow(function(count)
    return smallMoveXY(17, 22)
end)
planDelay(2)
-- line 2539
showMove('l')
showMove('l')
planDelay(1)
showMove('l')
planDelay(9)
level_planShow(function(count)
    addv(0, "help20")
    return true
end)
-- line 2571
showMove('r')
showMove('r')
showMove('r')
planDelay(3)
planDelay(3)
showMove('R')
showMove('R')
showMove('R')
planDelay(3)
showMove('L')
showMove('L')
showMove('L')
planDelay(2)
planDelay(3)
-- line 2617
level_planShow(function(count)
    return smallMoveXY(17, 26)
end)
showMove('l')
showMove('l')
showMove('l')
planDelay(3)
planDelay(3)
showMove('L')
showMove('L')
showMove('L')
planDelay(4)
level_planShow(function(count)
    return bigMoveXY(10, 26)
end)
planDelay(4)
planDelay(3)
-- line 2683
level_planShow(function(count)
    return smallMoveXY(18, 26)
end)
planDelay(15)
showMove('u')
planDelay(2)
showMove('l')
planDelay(1)
level_planShow(function(count)
    addm(0, "help21")
    return true
end)
planDelay(5)
planDelay(4)
-- line 2751
level_planShow(function(count)
    return bigMoveXY(15, 26)
end)
planDelay(4)
showMove('R')
planDelay(5)
planDelay(7)
-- line 2795
showMove('l')
planDelay(5)
showMove('l')
planDelay(8)
showMove('r')
planDelay(2)
showMove('r')
planDelay(3)
level_planShow(function(count)
    addv(0, "help22")
    return true
end)
planDelay(70)
-- line 2981
level_planShow(function(count)
    addm(0, "help23")
    return true
end)
planDelay(114)
