/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseInputSource;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.io.WstxInputSource;
import java.net.URL;
import javax.xml.stream.Location;

public final class CharArraySource
extends BaseInputSource {
    int mOffset;
    final Location mContentStart;

    CharArraySource(WstxInputSource parent, String fromEntity, char[] chars, int offset, int len, Location loc, URL src) {
        super(parent, fromEntity, loc.getPublicId(), loc.getSystemId(), src);
        this.mBuffer = chars;
        this.mOffset = offset;
        this.mInputLast = offset + len;
        this.mContentStart = loc;
    }

    public boolean fromInternalEntity() {
        return true;
    }

    protected void doInitInputLocation(WstxInputData reader) {
        reader.mCurrInputProcessed = this.mContentStart.getCharacterOffset();
        reader.mCurrInputRow = this.mContentStart.getLineNumber();
        reader.mCurrInputRowStart = -this.mContentStart.getColumnNumber() + 1;
    }

    public int readInto(WstxInputData reader) {
        if (this.mBuffer == null) {
            return -1;
        }
        int len = this.mInputLast - this.mOffset;
        if (len < 1) {
            return -1;
        }
        reader.mInputBuffer = this.mBuffer;
        reader.mInputPtr = this.mOffset;
        reader.mInputEnd = this.mInputLast;
        this.mOffset = this.mInputLast;
        return len;
    }

    public boolean readMore(WstxInputData reader, int minAmount) {
        int len;
        if (reader.mInputPtr >= reader.mInputEnd && (len = this.mInputLast - this.mOffset) >= minAmount) {
            return this.readInto(reader) > 0;
        }
        return false;
    }

    public void close() {
        this.mBuffer = null;
    }

    public void closeCompletely() {
        this.close();
    }
}

