/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkAclEntryDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.AuthRevBase;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReplaceNetworkAclEntry
extends BaseCmd {
    private static final String[] RULE_NUMBER_DESC = new String[]{"The rule number to replace."};
    private static final String[] CIDR_DESC = new String[]{"The IP range to regulate."};
    private static final String[] PROTOCOL_DESC = new String[]{"The IP protocol to regulate.  Set to 'all' for wildcard."};
    private static final String[] PORT_RANGE_DESC = new String[]{"The port range to regulate (TCP and UDP only)."};
    private static final String[] ICMP_TYPE_CODE_DESC = new String[]{"The ICMP type and code to regulate."};
    private static final String[] ALLOW_DESC = new String[]{"Sets the action to be taken on packets matching the rule to 'allow'.", "Must specify either this or deny."};
    private static final String[] DENY_DESC = new String[]{"Sets the action to be taken on packets matching the rule to 'deny'.", "Must specify either this or allow."};
    private static final String[] EGRESS_DESC = new String[]{"Specifies an egress rule.  The rule is otherwise assumed to be ingress."};

    public ReplaceNetworkAclEntry(String[] args) {
        super("ec2repnae", "ec2-replace-network-acl-entry");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"rule-number");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"RULE_NUMBER");
        OptionBuilder.withDescription((String)ReplaceNetworkAclEntry.joinDescription(RULE_NUMBER_DESC));
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)ReplaceNetworkAclEntry.joinDescription(CIDR_DESC));
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"protocol");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"PROTOCOL");
        OptionBuilder.withDescription((String)ReplaceNetworkAclEntry.joinDescription(PROTOCOL_DESC));
        options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"port-range");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"PORT_RANGE");
        OptionBuilder.withDescription((String)ReplaceNetworkAclEntry.joinDescription(PORT_RANGE_DESC));
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"icmp-type-code");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ICMP_TYPE_CODE");
        OptionBuilder.withDescription((String)ReplaceNetworkAclEntry.joinDescription(ICMP_TYPE_CODE_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        options.addOption(new Option(null, "egress", false, ReplaceNetworkAclEntry.joinDescription(EGRESS_DESC)));
        options.addOption(new Option(null, "allow", false, ReplaceNetworkAclEntry.joinDescription(ALLOW_DESC)));
        options.addOption(new Option(null, "deny", false, ReplaceNetworkAclEntry.joinDescription(DENY_DESC)));
        return options;
    }

    @Override
    protected String getOptionString() {
        return "NETWORK_ACL -n RULE_NUMBER -r CIDR [--egress] [-P PROTOCOL] (-p PORT_RANGE | -t ICMP_TYPE_CODE) {--allow | --deny}";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("rule-number");
        this.printOption("cidr");
        this.printOption("egress");
        this.printOption("protocol");
        this.printOption("port-range");
        this.printOption("icmp-type-code");
        this.printOption("allow");
        this.printOption("deny");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Replace an existing network ACL entry. ");
        System.out.println("     NETWORK_ACL is the network acl ID in which to replace the entry. ");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        boolean allow;
        int[] icmpArray;
        int[] rangeArray;
        this.assertNonOptionSet("NETWORK_ACL");
        this.warnIfTooManyNonOptions();
        String aclId = this.getNonOptions()[0];
        if (aclId == null || "".equals(aclId)) {
            throw new MissingNonOption("network-acl");
        }
        String ruleNumberString = this.getOptionValue("rule-number");
        if (ruleNumberString == null || "".equals(ruleNumberString)) {
            throw new MissingArgument("rule-number");
        }
        int ruleNumber = Integer.parseInt(ruleNumberString);
        String cidr = this.getOptionValue("cidr");
        if (cidr == null || "".equals(cidr)) {
            throw new MissingArgument("cidr");
        }
        boolean egress = this.getOptionValue("egress") != null;
        String protocol = this.getOptionValue("protocol");
        if (protocol == null || "".equals(protocol)) {
            throw new MissingArgument("protocol");
        }
        if (!("tcp".equals(protocol = protocol.toLowerCase()) || "udp".equals(protocol) || "6".equals(protocol) || "17".equals(protocol))) {
            if (this.isOptionSet("port-range")) {
                throw new InvalidArgumentCombination("Port range is for tcp and udp rules only.");
            }
            rangeArray = null;
        } else {
            String rangeString;
            rangeArray = !this.isOptionSet("port-range") ? new int[]{0, 65535} : ((rangeString = this.getOptionValue("port-range")) == null || "".equals(rangeString) ? new int[]{0, 65535} : this.parseRange(rangeString));
        }
        if (!"icmp".equals(protocol) && !"1".equals(protocol)) {
            if (this.isOptionSet("icmp-type-code")) {
                throw new InvalidArgumentCombination("Type and code is for icmp rules only.");
            }
            icmpArray = null;
        } else {
            String icmpString;
            icmpArray = !this.isOptionSet("icmp-type-code") ? new int[]{-1, -1} : ((icmpString = this.getOptionValue("icmp-type-code")) == null || "".equals(icmpString) ? new int[]{-1, -1} : AuthRevBase.parseIcmp(icmpString));
        }
        if (this.getOptionValue("allow") != null) {
            if (this.getOptionValue("deny") != null) {
                throw new InvalidArgumentCombination("Cannot specify both 'allow' and 'deny'.");
            }
            allow = true;
        } else {
            if (this.getOptionValue("deny") == null) {
                throw new InvalidArgumentCombination("Must specify either 'allow' or 'deny'.");
            }
            allow = false;
        }
        RequestResultPair result = jec2.replaceNetworkAclEntry(aclId, ruleNumber, cidr, egress, protocol, rangeArray, icmpArray, allow);
        out.output(System.out, (NetworkAclEntryDescription)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new ReplaceNetworkAclEntry(args).invoke();
    }
}

