/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InternetGatewayDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeInternetGateways
extends BaseCmd {
    public DescribeInternetGateways(String[] args) {
        super("ec2digw", "ec2-describe-internet-gateways");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "[INTERNET_GATEWAY [INTERNET_GATEWAY [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your internet gateways.");
        System.out.println("     INTERNET_GATEWAY is the internet gateway ID(s) to describe.");
        System.out.println("     If unspecified all your internet gateways will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        String[] gatewayIds = this.getNonOptions();
        RequestResultPair gateways = jec2.describeInternetGateways(gatewayIds, this.getFilters(true));
        for (InternetGatewayDescription gateway : (List)gateways.getResponse()) {
            out.output(System.out, gateway);
        }
        out.printRequestId(System.out, (RequestResult)gateways);
        return true;
    }

    public static void main(String[] args) {
        new DescribeInternetGateways(args).invoke();
    }
}

