/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.DeleteOnCloseFileInputStream;

public class CachedOutputStream
extends OutputStream {
    private OutputStream currentStream;
    private int threshold;
    private int totalLength = 0;
    private boolean inmem = false;
    private File tempFile = null;
    private File outputDir;

    public CachedOutputStream(int threshold, File outputDir) throws IOException {
        this.threshold = threshold;
        this.outputDir = outputDir;
        if (threshold <= 0) {
            this.createFileOutputStream();
        } else {
            this.currentStream = new ByteArrayOutputStream();
            this.inmem = true;
        }
    }

    public void close() throws IOException {
        this.currentStream.close();
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    public void flush() throws IOException {
        this.currentStream.flush();
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        return this.currentStream.toString();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.inmem && this.totalLength > this.threshold) {
            this.switchToFile();
        }
        this.currentStream.write(b, off, len);
    }

    private void switchToFile() throws IOException {
        byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
        this.createFileOutputStream();
        this.currentStream.write(bytes);
        this.inmem = false;
    }

    private void createFileOutputStream() throws IOException {
        this.tempFile = this.outputDir == null ? File.createTempFile("att", "tmp") : File.createTempFile("att", "tmp", this.outputDir);
        this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
    }

    public void write(byte[] b) throws IOException {
        this.totalLength += b.length;
        if (this.inmem && this.totalLength > this.threshold) {
            this.switchToFile();
        }
        this.currentStream.write(b);
    }

    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.inmem && this.totalLength > this.threshold) {
            this.switchToFile();
        }
        this.currentStream.write(b);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public InputStream getInputStream() {
        if (this.inmem) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
        }
        try {
            return new DeleteOnCloseFileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            throw new XFireRuntimeException("Cached file was deleted!!!", e);
        }
    }

    public void dispose() {
        if (!this.inmem) {
            this.tempFile.delete();
        }
    }
}

