/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.OutputStream;
import java.io.Writer;
import javolution.context.ObjectFactory;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamWriter;
import javolution.xml.stream.XMLStreamWriterImpl;

public abstract class XMLOutputFactory {
    public static final String IS_REPAIRING_NAMESPACES = "javolution.xml.stream.isRepairingNamespaces";
    public static final String REPAIRING_PREFIX = "javolution.xml.stream.repairingPrefix";
    public static final String INDENTATION = "javolution.xml.stream.indentation";
    public static final String AUTOMATIC_EMPTY_ELEMENTS = "javolution.xml.stream.automaticEmptyElements";
    private static final ObjectFactory XML_WRITER_FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLStreamWriterImpl();
        }

        protected void cleanup(Object object) {
            ((XMLStreamWriterImpl)object).reset();
        }
    };

    protected XMLOutputFactory() {
    }

    public static XMLOutputFactory newInstance() {
        return new Default();
    }

    public abstract XMLStreamWriter createXMLStreamWriter(Writer var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    private static final class Default
    extends XMLOutputFactory {
        private Boolean _isRepairingNamespaces = new Boolean(false);
        private String _repairingPrefix = "ns";
        private Boolean _automaticEmptyElements = new Boolean(false);
        private String _indentation;

        private Default() {
        }

        public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
            XMLStreamWriterImpl xMLStreamWriterImpl = this.newWriter();
            xMLStreamWriterImpl.setOutput(writer);
            return xMLStreamWriterImpl;
        }

        public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
            XMLStreamWriterImpl xMLStreamWriterImpl = this.newWriter();
            xMLStreamWriterImpl.setOutput(outputStream);
            return xMLStreamWriterImpl;
        }

        public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
            if (string == null || string.equals("UTF-8") || string.equals("utf-8")) {
                return this.createXMLStreamWriter(outputStream);
            }
            XMLStreamWriterImpl xMLStreamWriterImpl = this.newWriter();
            xMLStreamWriterImpl.setOutput(outputStream, string);
            return xMLStreamWriterImpl;
        }

        private XMLStreamWriterImpl newWriter() {
            XMLStreamWriterImpl xMLStreamWriterImpl = (XMLStreamWriterImpl)XML_WRITER_FACTORY.object();
            xMLStreamWriterImpl._objectFactory = XML_WRITER_FACTORY;
            xMLStreamWriterImpl.setRepairingNamespaces(this._isRepairingNamespaces);
            xMLStreamWriterImpl.setRepairingPrefix(this._repairingPrefix);
            xMLStreamWriterImpl.setIndentation(this._indentation);
            xMLStreamWriterImpl.setAutomaticEmptyElements(this._automaticEmptyElements);
            return xMLStreamWriterImpl;
        }

        public void setProperty(String string, Object object) throws IllegalArgumentException {
            if (string.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES)) {
                this._isRepairingNamespaces = (Boolean)object;
            } else if (string.equals(XMLOutputFactory.REPAIRING_PREFIX)) {
                this._repairingPrefix = (String)object;
            } else if (string.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS)) {
                this._automaticEmptyElements = (Boolean)object;
            } else if (string.equals(XMLOutputFactory.INDENTATION)) {
                this._indentation = (String)object;
            } else {
                throw new IllegalArgumentException("Property: " + string + " not supported");
            }
        }

        public Object getProperty(String string) throws IllegalArgumentException {
            if (string.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES)) {
                return this._isRepairingNamespaces;
            }
            if (string.equals(XMLOutputFactory.REPAIRING_PREFIX)) {
                return this._repairingPrefix;
            }
            if (string.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS)) {
                return this._automaticEmptyElements;
            }
            if (string.equals(XMLOutputFactory.INDENTATION)) {
                return this._indentation;
            }
            throw new IllegalArgumentException("Property: " + string + " not supported");
        }

        public boolean isPropertySupported(String string) {
            return string.equals(XMLOutputFactory.IS_REPAIRING_NAMESPACES) || string.equals(XMLOutputFactory.REPAIRING_PREFIX) || string.equals(XMLOutputFactory.AUTOMATIC_EMPTY_ELEMENTS) || string.equals(XMLOutputFactory.INDENTATION);
        }
    }
}

