/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.model;

import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCache {
    private int myMaxCapacity;
    private int myCurCapacity;
    private final Map<String, Pattern> myPatternMap = new HashMap<String, Pattern>();
    private final Map<String, LinkedHashSet<TableFilteringRow>> myFilterMap = new HashMap<String, LinkedHashSet<TableFilteringRow>>();

    public void clear() {
        this.myFilterMap.clear();
        this.myPatternMap.clear();
    }

    public void update(TableFilteringRow row) {
        for (String pattern : this.myFilterMap.keySet()) {
            Pattern p = this.myPatternMap.get(pattern);
            boolean include = row.include(p);
            Set set = this.myFilterMap.get(pattern);
            boolean contains = set.contains(row);
            if (include && !contains) {
                set.add(row);
                continue;
            }
            if (include || !contains) continue;
            set.remove(row);
        }
    }

    public List<TableFilteringRow> include(Collection<TableFilteringRow> rowCollection, Pattern pattern) {
        String stringPattern = pattern.pattern();
        LinkedHashSet<TableFilteringRow> newRowSet = this.myFilterMap.get(stringPattern);
        if (newRowSet != null) {
            ArrayList<TableFilteringRow> outList = new ArrayList<TableFilteringRow>(newRowSet);
            return outList;
        }
        String prefix = this.getMaxPrefix(stringPattern);
        newRowSet = new LinkedHashSet();
        if (prefix == null) {
            for (TableFilteringRow filteringRow : rowCollection) {
                if (!filteringRow.include(pattern)) continue;
                newRowSet.add(filteringRow);
            }
        } else {
            Set helpSet = this.myFilterMap.get(prefix);
            for (TableFilteringRow filteringRow : helpSet) {
                if (!filteringRow.include(pattern)) continue;
                newRowSet.add(filteringRow);
            }
        }
        if (newRowSet.size() > 0) {
            this.myFilterMap.put(stringPattern, newRowSet);
            this.myPatternMap.put(stringPattern, pattern);
            this.myCurCapacity += newRowSet.size() + 10;
            return new ArrayList<TableFilteringRow>(newRowSet);
        }
        return Collections.EMPTY_LIST;
    }

    public String getMaxPrefix(String filter) {
        int size = 0;
        String prefix = null;
        for (String s : this.myFilterMap.keySet()) {
            if (!filter.startsWith(s) || size >= s.length()) continue;
            size = s.length();
            prefix = s;
        }
        return prefix;
    }
}

