/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracker.eapi.alpha;

import com.almworks.tracker.eapi.alpha.ConnectionState;

public class TrackerConnectionStatus {
    public static final TrackerConnectionStatus NOT_CONNECTED = new TrackerConnectionStatus(ConnectionState.NOT_CONNECTED);
    private final ConnectionState myConnectionState;
    private final String myTrackerName;
    private final String myTrackerVersion;
    private final String myWorkspaceDirectory;
    private final int myTrackerConnectionId;

    public TrackerConnectionStatus(ConnectionState connectionState) {
        this(connectionState, null, null, null, 0);
    }

    public TrackerConnectionStatus(ConnectionState connectionState, String string, String string2, String string3, int n) {
        this.myConnectionState = connectionState;
        this.myTrackerName = string;
        this.myTrackerVersion = string2;
        this.myWorkspaceDirectory = string3;
        this.myTrackerConnectionId = n;
    }

    public boolean isConnected() {
        return this.getConnectionState() == ConnectionState.CONNECTED;
    }

    public ConnectionState getConnectionState() {
        return this.myConnectionState;
    }

    public String getTrackerName() {
        return this.myTrackerName;
    }

    public String getTrackerVersion() {
        return this.myTrackerVersion;
    }

    public String getWorkspaceDirectory() {
        return this.myWorkspaceDirectory;
    }

    public int getTrackerConnectionId() {
        return this.myTrackerConnectionId;
    }

    public String toString() {
        return this.myConnectionState.name() + ":" + this.myTrackerName + ":" + this.myTrackerVersion + ":" + this.myWorkspaceDirectory + ":" + this.myTrackerConnectionId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TrackerConnectionStatus trackerConnectionStatus = (TrackerConnectionStatus)object;
        if (this.myTrackerConnectionId != trackerConnectionStatus.myTrackerConnectionId) {
            return false;
        }
        if (this.myConnectionState != trackerConnectionStatus.myConnectionState) {
            return false;
        }
        if (this.myTrackerName != null ? !this.myTrackerName.equals(trackerConnectionStatus.myTrackerName) : trackerConnectionStatus.myTrackerName != null) {
            return false;
        }
        if (this.myTrackerVersion != null ? !this.myTrackerVersion.equals(trackerConnectionStatus.myTrackerVersion) : trackerConnectionStatus.myTrackerVersion != null) {
            return false;
        }
        return !(this.myWorkspaceDirectory != null ? !this.myWorkspaceDirectory.equals(trackerConnectionStatus.myWorkspaceDirectory) : trackerConnectionStatus.myWorkspaceDirectory != null);
    }

    public int hashCode() {
        int n = this.myConnectionState.hashCode();
        n = 29 * n + (this.myTrackerName != null ? this.myTrackerName.hashCode() : 0);
        n = 29 * n + (this.myTrackerVersion != null ? this.myTrackerVersion.hashCode() : 0);
        n = 29 * n + (this.myWorkspaceDirectory != null ? this.myWorkspaceDirectory.hashCode() : 0);
        n = 29 * n + this.myTrackerConnectionId;
        return n;
    }
}

