/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.WebResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJobServlet
extends HttpServlet {
    private static final long serialVersionUID = -6850701762586992604L;
    private static LogWriter log = LogWriter.getInstance();
    public static final String CONTEXT_PATH = "/kettle/addJob";
    private JobMap jobMap;
    private SocketRepository socketRepository;

    public AddJobServlet(JobMap jobMap, SocketRepository socketRepository) {
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRequestURI().equals("/kettle/addJob/")) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Addition of job requested", new Object[0]);
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "Encoding: " + request.getCharacterEncoding(), new Object[0]);
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add job</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        try {
            int c;
            StringBuffer xml = new StringBuffer();
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            JobConfiguration jobConfiguration = JobConfiguration.fromXML(xml.toString());
            JobMeta jobMeta = jobConfiguration.getJobMeta();
            JobExecutionConfiguration jobExecutionConfiguration = jobConfiguration.getJobExecutionConfiguration();
            log.setLogLevel(jobExecutionConfiguration.getLogLevel());
            jobMeta.setArguments(jobExecutionConfiguration.getArgumentStrings());
            jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
            Map<String, String> params = jobExecutionConfiguration.getParams();
            for (String param : params.keySet()) {
                String value = params.get(param);
                jobMeta.setParameterValue(param, value);
            }
            final Repository repository = jobConfiguration.getJobExecutionConfiguration().getRepository();
            Job job = new Job(LogWriter.getInstance(), StepLoader.getInstance(), repository, jobMeta);
            job.setSocketRepository(this.socketRepository);
            Job oldOne = this.jobMap.getJob(job.getJobname());
            if (oldOne != null && (oldOne.isActive() || oldOne.isInitialized() && !oldOne.isFinished())) {
                throw new Exception("A job with the same name exists and is not idle." + Const.CR + "Please stop this job first.");
            }
            Appender appender = this.jobMap.getAppender(job.getJobname());
            if (appender != null) {
                log.removeAppender(appender);
                appender.close();
            }
            job.initializeVariablesFrom(null);
            job.getJobMeta().setInternalKettleVariables(job);
            job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
            this.jobMap.addJob(jobMeta.getName(), job, jobConfiguration);
            if (repository != null) {
                job.addJobListener(new JobListener(){

                    public void jobFinished(Job job) {
                        repository.disconnect();
                    }
                });
            }
            job.addJobListener(new JobListener(){

                public void jobFinished(Job job) {
                    try {
                        job.endProcessing("end", job.getResult());
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), "There was an error while logging the job result to the logging table", (Throwable)e);
                    }
                }
            });
            String message = oldOne != null ? "Job '" + job.getJobname() + "' was replaced in the list." : "Job '" + job.getJobname() + "' was added to the list.";
            if (useXML) {
                out.println(new WebResult("OK", message));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"/kettle/jobStatus?name=" + job.getJobname() + "\">Go to the job status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    protected String[] getAllArgumentStrings(Map<String, String> arguments) {
        if (arguments == null || arguments.size() == 0) {
            return null;
        }
        Object[] argNames = arguments.keySet().toArray(new String[arguments.size()]);
        Arrays.sort(argNames);
        String[] values = new String[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            values[i] = arguments.get(argNames[i]);
        }
        return values;
    }

    public String toString() {
        return "Add Job";
    }
}

