/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.vote.AbstractAclVoter;
import org.springframework.security.vote.LabeledData;
import org.springframework.util.Assert;

public class LabelBasedAclVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$vote$LabelBasedAclVoter == null ? (class$org$springframework$security$vote$LabelBasedAclVoter = LabelBasedAclVoter.class$("org.springframework.security.vote.LabelBasedAclVoter")) : class$org$springframework$security$vote$LabelBasedAclVoter));
    private Map labelMap = null;
    private String attributeIndicatingLabeledOperation = null;
    private boolean allowAccessIfNoAttributesAreLabeled = true;
    static /* synthetic */ Class class$org$springframework$security$vote$LabelBasedAclVoter;

    public void setAllowAccessIfNoAttributesAreLabeled(boolean allowAccessIfNoAttributesAreLabeled) {
        this.allowAccessIfNoAttributesAreLabeled = allowAccessIfNoAttributesAreLabeled;
    }

    public void setAttributeIndicatingLabeledOperation(String attributeIndicatingLabeledOperation) {
        this.attributeIndicatingLabeledOperation = attributeIndicatingLabeledOperation;
    }

    public void setLabelMap(Map labelMap) {
        this.labelMap = labelMap;
    }

    public boolean supports(ConfigAttribute attribute) {
        if (attribute.getAttribute().equals(this.attributeIndicatingLabeledOperation)) {
            logger.debug((Object)(attribute + " is supported."));
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(attribute + " is unsupported."));
        }
        return false;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int result = 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==========================================================");
        }
        if (this.supports((ConfigAttribute)config.getConfigAttributes().iterator().next())) {
            result = -1;
            Vector<String> userLabels = new Vector<String>();
            for (int i = 0; i < authentication.getAuthorities().length; ++i) {
                if (!this.labelMap.containsKey(authentication.getAuthorities()[i].getAuthority())) continue;
                String userLabel = authentication.getAuthorities()[i].getAuthority();
                userLabels.add(userLabel);
                logger.debug((Object)("Adding " + userLabel + " to <<<" + authentication.getName() + "'s>>> authorized label list"));
            }
            MethodInvocation invocation = (MethodInvocation)object;
            int matches = 0;
            int misses = 0;
            int labeledArguments = 0;
            for (int j = 0; j < invocation.getArguments().length; ++j) {
                if (!(invocation.getArguments()[j] instanceof LabeledData)) continue;
                ++labeledArguments;
                boolean matched = false;
                String argumentDataLabel = ((LabeledData)invocation.getArguments()[j]).getLabel();
                logger.debug((Object)("Argument[" + j + "/" + invocation.getArguments()[j].getClass().getName() + "] has a data label of " + argumentDataLabel));
                Vector validDataLabels = new Vector();
                for (int i = 0; i < userLabels.size(); ++i) {
                    validDataLabels.addAll((List)this.labelMap.get(userLabels.get(i)));
                }
                logger.debug((Object)("The valid labels for user label " + userLabels + " are " + validDataLabels));
                Iterator dataLabelIter = validDataLabels.iterator();
                while (dataLabelIter.hasNext()) {
                    String validDataLabel = (String)dataLabelIter.next();
                    if (!argumentDataLabel.equals(validDataLabel)) continue;
                    logger.debug((Object)(userLabels + " maps to " + validDataLabel + " which matches the argument"));
                    matched = true;
                }
                if (matched) {
                    logger.debug((Object)"We have a match!");
                    ++matches;
                    continue;
                }
                logger.debug((Object)"We have a miss!");
                ++misses;
            }
            Assert.isTrue((matches + misses == labeledArguments ? 1 : 0) != 0, (String)("The matches (" + matches + ") and misses (" + misses + " ) don't add up (" + labeledArguments + ")"));
            logger.debug((Object)("We have " + matches + " matches and " + misses + " misses and " + labeledArguments + " labeled arguments."));
            if (matches > 0 && misses == 0) {
                result = 1;
            } else if (labeledArguments == 0) {
                result = this.allowAccessIfNoAttributesAreLabeled ? 1 : -1;
            }
        }
        if (logger.isDebugEnabled()) {
            switch (result) {
                case 1: {
                    logger.debug((Object)"===== Access is granted =====");
                    break;
                }
                case -1: {
                    logger.debug((Object)"===== Access is denied =====");
                    break;
                }
                case 0: {
                    logger.debug((Object)"===== Abstaining =====");
                }
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

